/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.plugin.base.Versions;
import io.trino.plugin.tpcds.TpcdsMetadata;
import io.trino.plugin.tpcds.TpcdsNodePartitioningProvider;
import io.trino.plugin.tpcds.TpcdsRecordSetProvider;
import io.trino.plugin.tpcds.TpcdsSplitManager;
import io.trino.plugin.tpcds.TpcdsTransactionHandle;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Map;

public class TpcdsConnectorFactory
implements ConnectorFactory {
    private final int defaultSplitsPerNode;

    public TpcdsConnectorFactory() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public TpcdsConnectorFactory(int defaultSplitsPerNode) {
        Preconditions.checkState((defaultSplitsPerNode > 0 ? 1 : 0) != 0, (Object)"default splits per node is negative");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpcds";
    }

    public Connector create(String catalogName, final Map<String, String> config, ConnectorContext context) {
        Versions.checkSpiVersion((ConnectorContext)context, (ConnectorFactory)this);
        final int splitsPerNode = this.getSplitsPerNode(config);
        final NodeManager nodeManager = context.getNodeManager();
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
                return TpcdsTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
                return new TpcdsMetadata();
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpcdsSplitManager(nodeManager, splitsPerNode, TpcdsConnectorFactory.this.isWithNoSexism(config));
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpcdsRecordSetProvider();
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpcdsNodePartitioningProvider(nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpcds.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpcds.splits-per-node");
        }
    }

    private boolean isWithNoSexism(Map<String, String> properties) {
        return Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)properties.get("tpcds.with-no-sexism"), (Object)String.valueOf(false)));
    }
}

