/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpcds.TpcdsSplit;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;

public class TpcdsNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;
    private final int splitsPerNode;

    public TpcdsNodePartitioningProvider(NodeManager nodeManager, int splitsPerNode) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.nodeManager = nodeManager;
        this.splitsPerNode = splitsPerNode;
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No TPCDS nodes available");
        List sortedNodes = (List)nodes.stream().sorted(Comparator.comparing(node -> node.getHostAndPort().toString())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder bucketToNode = ImmutableList.builder();
        for (Node node2 : sortedNodes) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                bucketToNode.add((Object)node2);
            }
        }
        return ConnectorBucketNodeMap.createBucketNodeMap((List)bucketToNode.build());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((TpcdsSplit)value).getPartNumber();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        throw new UnsupportedOperationException();
    }
}

