/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.trino.tpcds.Parallel;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.TpcdsException;
import io.trino.tpcds.row.TableRow;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Results
implements Iterable<List<List<String>>> {
    private final Table table;
    private final long startingRowNumber;
    private final long rowCount;
    private final Session session;

    public Results(Table table, long startingRowNumber, long rowCount, Session session) {
        this.table = table;
        this.startingRowNumber = startingRowNumber;
        this.rowCount = rowCount;
        this.session = session;
    }

    public static Results constructResults(Table table, Session session) {
        Parallel.ChunkBoundaries chunkBoundaries = Parallel.splitWork(table, session);
        return new Results(table, chunkBoundaries.getFirstRow(), chunkBoundaries.getLastRow(), session);
    }

    public static Results constructResults(Table table, long startingRowNumber, long endingRowNumber, Session session) {
        return new Results(table, startingRowNumber, endingRowNumber, session);
    }

    @Override
    public Iterator<List<List<String>>> iterator() {
        return new ResultsIterator(this.table, this.startingRowNumber, this.rowCount, this.session);
    }

    private static class ResultsIterator
    extends AbstractIterator<List<List<String>>> {
        private final long endingRowNumber;
        private final Table table;
        private final Session session;
        private long rowNumber;
        private final RowGenerator rowGenerator;
        private final RowGenerator parentRowGenerator;
        private final RowGenerator childRowGenerator;

        public ResultsIterator(Table table, long startingRowNumber, long endingRowNumber, Session session) {
            Objects.requireNonNull(table, "table is null");
            Objects.requireNonNull(session, "session is null");
            Preconditions.checkArgument((startingRowNumber >= 1L ? 1 : 0) != 0, (String)"starting row number is less than 1: %s", (long)startingRowNumber);
            Preconditions.checkArgument((endingRowNumber <= session.getScaling().getRowCount(table) ? 1 : 0) != 0, (String)"starting row number is greater than the total rows in %s: %s", (Object)((Object)table), (long)endingRowNumber);
            this.table = table;
            this.rowNumber = startingRowNumber;
            this.endingRowNumber = endingRowNumber;
            this.session = session;
            try {
                this.rowGenerator = table.getRowGeneratorClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.parentRowGenerator = table.isChild() ? table.getParent().getRowGeneratorClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
                this.childRowGenerator = table.hasChild() ? table.getChild().getRowGeneratorClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TpcdsException(e.toString());
            }
            this.skipRowsUntilStartingRowNumber(startingRowNumber);
        }

        private void skipRowsUntilStartingRowNumber(long startingRowNumber) {
            this.rowGenerator.skipRowsUntilStartingRowNumber(startingRowNumber);
            if (this.parentRowGenerator != null) {
                this.parentRowGenerator.skipRowsUntilStartingRowNumber(startingRowNumber);
            }
            if (this.childRowGenerator != null) {
                this.childRowGenerator.skipRowsUntilStartingRowNumber(startingRowNumber);
            }
        }

        protected List<List<String>> computeNext() {
            if (this.rowNumber > this.endingRowNumber) {
                return (List)this.endOfData();
            }
            RowGeneratorResult result = this.rowGenerator.generateRowAndChildRows(this.rowNumber, this.session, this.parentRowGenerator, this.childRowGenerator);
            Object tableRows = result.getRowAndChildRows().stream().map(TableRow::getValues).collect(Collectors.toList());
            if (result.shouldEndRow()) {
                this.rowStop();
                ++this.rowNumber;
            }
            if (result.getRowAndChildRows().isEmpty()) {
                tableRows = this.computeNext();
            }
            return tableRows;
        }

        private void rowStop() {
            this.rowGenerator.consumeRemainingSeedsForRow();
            if (this.parentRowGenerator != null) {
                this.parentRowGenerator.consumeRemainingSeedsForRow();
            }
            if (this.childRowGenerator != null) {
                this.childRowGenerator.consumeRemainingSeedsForRow();
            }
        }
    }
}

