/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import com.google.common.primitives.Ints;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import java.io.InputStream;
import java.util.Set;

public class DefaultingJsonResponseHandler<T>
implements ResponseHandler<T, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final JsonCodec<T> jsonCodec;
    private final T defaultValue;
    private final Set<Integer> successfulResponseCodes;

    public static <T> DefaultingJsonResponseHandler<T> createDefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue) {
        return new DefaultingJsonResponseHandler<T>(jsonCodec, defaultValue);
    }

    public static <T> DefaultingJsonResponseHandler<T> createDefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        return new DefaultingJsonResponseHandler<T>(jsonCodec, defaultValue, firstSuccessfulResponseCode, otherSuccessfulResponseCodes);
    }

    private DefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue) {
        this(jsonCodec, defaultValue, 200, 201, 202, 203, 204, 205, 206);
    }

    private DefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        this.jsonCodec = jsonCodec;
        this.defaultValue = defaultValue;
        this.successfulResponseCodes = ImmutableSet.builder().add((Object)firstSuccessfulResponseCode).addAll((Iterable)Ints.asList((int[])otherSuccessfulResponseCodes)).build();
    }

    @Override
    public T handleException(Request request, Exception exception) {
        return this.defaultValue;
    }

    @Override
    public T handle(Request request, Response response) {
        if (!this.successfulResponseCodes.contains(response.getStatusCode())) {
            return this.defaultValue;
        }
        String contentType = response.getHeader("Content-Type");
        if (contentType != null && !MediaType.parse((String)contentType).is(MEDIA_TYPE_JSON)) {
            return this.defaultValue;
        }
        try {
            return (T)this.jsonCodec.fromJson(ByteStreams.toByteArray((InputStream)response.getInputStream()));
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }
}

