/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.tpcds.TpcdsColumnHandle;
import io.trino.plugin.tpcds.TpcdsTableHandle;
import io.trino.plugin.tpcds.statistics.TpcdsTableStatisticsFactory;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.tpcds.Table;
import io.trino.tpcds.column.Column;
import io.trino.tpcds.column.ColumnType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TpcdsMetadata
implements ConnectorMetadata {
    public static final String TINY_SCHEMA_NAME = "tiny";
    public static final double TINY_SCALE_FACTOR = 0.01;
    public static final List<String> SCHEMA_NAMES = ImmutableList.of((Object)"tiny", (Object)"sf1", (Object)"sf10", (Object)"sf100", (Object)"sf300", (Object)"sf1000", (Object)"sf3000", (Object)"sf10000", (Object)"sf30000", (Object)"sf100000");
    private final Set<String> tableNames;
    private final TpcdsTableStatisticsFactory tpcdsTableStatisticsFactory = new TpcdsTableStatisticsFactory();

    public TpcdsMetadata() {
        ImmutableSet.Builder tableNames = ImmutableSet.builder();
        for (Table tpcdsTable : Table.getBaseTables()) {
            tableNames.add((Object)tpcdsTable.getName().toLowerCase(Locale.ENGLISH));
        }
        this.tableNames = tableNames.build();
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return TpcdsMetadata.schemaNameToScaleFactor(schemaName) > 0.0;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return SCHEMA_NAMES;
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.tableNames.contains(tableName.getTableName())) {
            return null;
        }
        double scaleFactor = TpcdsMetadata.schemaNameToScaleFactor(tableName.getSchemaName());
        if (scaleFactor <= 0.0) {
            return null;
        }
        return new TpcdsTableHandle(tableName.getTableName(), scaleFactor);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TpcdsTableHandle tpcdsTableHandle = (TpcdsTableHandle)tableHandle;
        Table table = Table.getTable((String)tpcdsTableHandle.getTableName());
        String schemaName = TpcdsMetadata.scaleFactorSchemaName(tpcdsTableHandle.getScaleFactor());
        return TpcdsMetadata.getTableMetadata(schemaName, table);
    }

    private static ConnectorTableMetadata getTableMetadata(String schemaName, Table tpcdsTable) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (Column column : tpcdsTable.getColumns()) {
            columns.add((Object)new ColumnMetadata(column.getName(), TpcdsMetadata.getTrinoType(column.getType())));
        }
        SchemaTableName tableName = new SchemaTableName(schemaName, tpcdsTable.getName());
        return new ConnectorTableMetadata(tableName, (List)columns.build());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TpcdsTableHandle tpcdsTableHandle = (TpcdsTableHandle)tableHandle;
        Table table = Table.getTable((String)tpcdsTableHandle.getTableName());
        String schemaName = TpcdsMetadata.scaleFactorSchemaName(tpcdsTableHandle.getScaleFactor());
        return this.tpcdsTableStatisticsFactory.create(schemaName, table, this.getColumnHandles(session, tableHandle));
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(session, tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpcdsColumnHandle(columnMetadata.getName(), columnMetadata.getType()));
        }
        return builder.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        String columnName = ((TpcdsColumnHandle)columnHandle).getColumnName();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Table '%s' does not have column '%s'", tableMetadata.getTable(), columnName));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (String schemaName : this.getSchemaNames(session, prefix.getSchema())) {
            for (Table tpcdsTable : Table.getBaseTables()) {
                if (!prefix.getTable().map(tpcdsTable.getName()::equals).orElse(true).booleanValue()) continue;
                ConnectorTableMetadata tableMetadata = TpcdsMetadata.getTableMetadata(schemaName, tpcdsTable);
                tableColumns.put((Object)new SchemaTableName(schemaName, tpcdsTable.getName()), (Object)tableMetadata.getColumns());
            }
        }
        return tableColumns.buildOrThrow();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> filterSchema) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : this.getSchemaNames(session, filterSchema)) {
            for (Table tpcdsTable : Table.getBaseTables()) {
                builder.add((Object)new SchemaTableName(schemaName, tpcdsTable.getName()));
            }
        }
        return builder.build();
    }

    private List<String> getSchemaNames(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isEmpty()) {
            return this.listSchemaNames(session);
        }
        if (TpcdsMetadata.schemaNameToScaleFactor(schemaName.get()) > 0.0) {
            return ImmutableList.of((Object)schemaName.get());
        }
        return ImmutableList.of();
    }

    private static String scaleFactorSchemaName(double scaleFactor) {
        return "sf" + scaleFactor;
    }

    public static double schemaNameToScaleFactor(String schemaName) {
        if (TINY_SCHEMA_NAME.equals(schemaName)) {
            return 0.01;
        }
        if (!schemaName.startsWith("sf")) {
            return -1.0;
        }
        try {
            return Double.parseDouble(schemaName.substring(2));
        }
        catch (Exception ignored) {
            return -1.0;
        }
    }

    public static Type getTrinoType(ColumnType tpcdsType) {
        switch (tpcdsType.getBase()) {
            case IDENTIFIER: {
                return BigintType.BIGINT;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DECIMAL: {
                return DecimalType.createDecimalType((int)((Integer)tpcdsType.getPrecision().get()), (int)((Integer)tpcdsType.getScale().get()));
            }
            case CHAR: {
                return CharType.createCharType((int)((Integer)tpcdsType.getPrecision().get()));
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((Integer)tpcdsType.getPrecision().get()));
            }
            case TIME: {
                return TimeType.TIME_MILLIS;
            }
        }
        throw new IllegalArgumentException("Unsupported TPC-DS type " + String.valueOf(tpcdsType));
    }
}

