/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import org.weakref.jmx.AnnotationUtils;
import org.weakref.jmx.MBean;
import org.weakref.jmx.MBeanAttribute;
import org.weakref.jmx.MBeanBuilder;
import org.weakref.jmx.MBeanFeature;
import org.weakref.jmx.MBeanOperation;
import org.weakref.jmx.NestedMBeanAttribute;
import org.weakref.jmx.NestedMBeanOperation;
import org.weakref.jmx.ReflectionMBeanAttribute;
import org.weakref.jmx.ReflectionUtils;

public class MBeanAttributeBuilder {
    private static final Pattern getterOrSetterPattern = Pattern.compile("(get|set|is)(.+)");
    private Object target;
    private String name;
    private Method concreteGetter;
    private Method annotatedGetter;
    private Method concreteSetter;
    private Method annotatedSetter;
    private boolean flatten;
    private boolean nested;

    public MBeanAttributeBuilder onInstance(Object target) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        this.target = target;
        return this;
    }

    public MBeanAttributeBuilder named(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        return this;
    }

    public MBeanAttributeBuilder withConcreteGetter(Method concreteGetter) {
        if (concreteGetter == null) {
            throw new NullPointerException("concreteGetter is null");
        }
        if (!ReflectionUtils.isValidGetter(concreteGetter)) {
            throw new IllegalArgumentException("Method is not a valid getter: " + String.valueOf(concreteGetter));
        }
        this.concreteGetter = concreteGetter;
        return this;
    }

    public MBeanAttributeBuilder withAnnotatedGetter(Method annotatedGetter) {
        if (annotatedGetter == null) {
            throw new NullPointerException("annotatedGetter is null");
        }
        if (!ReflectionUtils.isValidGetter(annotatedGetter)) {
            throw new IllegalArgumentException("Method is not a valid getter: " + String.valueOf(annotatedGetter));
        }
        this.annotatedGetter = annotatedGetter;
        return this;
    }

    public MBeanAttributeBuilder withConcreteSetter(Method concreteSetter) {
        if (concreteSetter == null) {
            throw new NullPointerException("concreteSetter is null");
        }
        if (!ReflectionUtils.isValidSetter(concreteSetter)) {
            throw new IllegalArgumentException("Method is not a valid setter: " + String.valueOf(concreteSetter));
        }
        this.concreteSetter = concreteSetter;
        return this;
    }

    public MBeanAttributeBuilder withAnnotatedSetter(Method annotatedSetter) {
        if (annotatedSetter == null) {
            throw new NullPointerException("annotatedSetter is null");
        }
        if (!ReflectionUtils.isValidSetter(annotatedSetter)) {
            throw new IllegalArgumentException("Method is not a valid setter: " + String.valueOf(annotatedSetter));
        }
        this.annotatedSetter = annotatedSetter;
        return this;
    }

    public MBeanAttributeBuilder flatten() {
        this.flatten = true;
        return this;
    }

    public MBeanAttributeBuilder nested() {
        this.nested = true;
        return this;
    }

    public Collection<? extends MBeanFeature> build() {
        if (this.target == null) {
            throw new IllegalArgumentException("JmxAttribute must have a target object");
        }
        String attributeName = this.name;
        if (attributeName == null) {
            attributeName = MBeanAttributeBuilder.getAttributeName(this.concreteGetter, this.concreteSetter, this.annotatedGetter, this.annotatedSetter);
        }
        if (this.flatten || AnnotationUtils.isFlatten(this.annotatedGetter)) {
            if (this.concreteGetter == null) {
                throw new IllegalArgumentException("Flattened JmxAttribute must have a concrete getter");
            }
            Object value = null;
            try {
                value = this.concreteGetter.invoke(this.target, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) {
                return Collections.emptySet();
            }
            MBean mbean = new MBeanBuilder(value).build();
            ArrayList<MBeanFeature> features = new ArrayList<MBeanFeature>();
            features.addAll(mbean.getAttributes());
            features.addAll(mbean.getOperations());
            return Collections.unmodifiableCollection(features);
        }
        if (this.nested || AnnotationUtils.isNested(this.annotatedGetter)) {
            if (this.concreteGetter == null) {
                throw new IllegalArgumentException("Nested JmxAttribute must have a concrete getter");
            }
            Object value = null;
            try {
                value = this.concreteGetter.invoke(this.target, new Object[0]);
            }
            catch (Exception mbean) {
                // empty catch block
            }
            if (value == null) {
                return Collections.emptySet();
            }
            MBean mbean = new MBeanBuilder(value).build();
            ArrayList<MBeanFeature> features = new ArrayList<MBeanFeature>();
            for (MBeanAttribute attribute : mbean.getAttributes()) {
                features.add(new NestedMBeanAttribute(attributeName, attribute));
            }
            for (MBeanOperation operation : mbean.getOperations()) {
                features.add(new NestedMBeanOperation(attributeName, operation));
            }
            return Collections.unmodifiableCollection(features);
        }
        if (this.concreteGetter == null && this.concreteSetter == null) {
            throw new IllegalArgumentException("JmxAttribute must have a concrete getter or setter method");
        }
        Class<?> attributeType = this.concreteGetter != null ? this.concreteGetter.getReturnType() : this.concreteSetter.getParameterTypes()[0];
        Descriptor descriptor = null;
        if (this.annotatedGetter != null) {
            descriptor = AnnotationUtils.buildDescriptor(this.annotatedGetter);
        }
        if (this.annotatedSetter != null) {
            Descriptor setterDescriptor = AnnotationUtils.buildDescriptor(this.annotatedSetter);
            descriptor = descriptor == null ? setterDescriptor : ImmutableDescriptor.union(descriptor, setterDescriptor);
        }
        String description = AnnotationUtils.getDescription(descriptor, this.annotatedGetter, this.annotatedSetter);
        MBeanAttributeInfo mbeanAttributeInfo = new MBeanAttributeInfo(attributeName, attributeType.getName(), description, this.concreteGetter != null, this.concreteSetter != null, this.concreteGetter != null && this.concreteGetter.getName().startsWith("is"), descriptor);
        return Collections.singleton(new ReflectionMBeanAttribute(mbeanAttributeInfo, this.target, this.concreteGetter, this.concreteSetter));
    }

    private static String getAttributeName(Method ... methods) {
        for (Method method : methods) {
            Matcher matcher;
            if (method == null || !(matcher = getterOrSetterPattern.matcher(method.getName())).matches()) continue;
            return matcher.group(2);
        }
        for (Method method : methods) {
            if (method == null) continue;
            return method.getName();
        }
        return null;
    }
}

