/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.tpcds.TpcdsSplit;
import io.trino.plugin.tpcds.TpcdsSplitManager;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToIntFunction;

public class TpcdsNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;

    @Inject
    public TpcdsNodePartitioningProvider(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public Optional<ConnectorBucketNodeMap> getBucketNodeMapping(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No TPCDS nodes available");
        List sortedNodes = (List)nodes.stream().sorted(Comparator.comparing(node -> node.getHostAndPort().toString())).collect(ImmutableList.toImmutableList());
        int splitCount = TpcdsSplitManager.getSplitCount(session, nodes.size());
        ImmutableList.Builder bucketToNode = ImmutableList.builder();
        for (int i = 0; i < splitCount; ++i) {
            bucketToNode.add((Object)((Node)sortedNodes.get(i % nodes.size())));
        }
        return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((List)bucketToNode.build()));
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, int bucketCount) {
        return value -> ((TpcdsSplit)value).getPartNumber();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        throw new UnsupportedOperationException();
    }
}

