/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpcds.TpcdsColumnHandle;
import io.trino.plugin.tpcds.TpcdsRecordSet;
import io.trino.plugin.tpcds.TpcdsSplit;
import io.trino.plugin.tpcds.TpcdsTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import io.trino.tpcds.Results;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.column.Column;
import java.util.List;

public class TpcdsRecordSetProvider
implements ConnectorRecordSetProvider {
    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession connectorSession, ConnectorSplit split, ConnectorTableHandle tableHandle, List<? extends ColumnHandle> columns) {
        TpcdsSplit tpcdsSplit = (TpcdsSplit)split;
        TpcdsTableHandle tpcdsTable = (TpcdsTableHandle)tableHandle;
        Table table = Table.getTable((String)tpcdsTable.tableName());
        double scaleFactor = tpcdsTable.scaleFactor();
        int partNumber = tpcdsSplit.getPartNumber();
        int totalParts = tpcdsSplit.getTotalParts();
        boolean noSexism = tpcdsSplit.isNoSexism();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = ((TpcdsColumnHandle)columnHandle).columnName();
            builder.add((Object)table.getColumn(columnName));
        }
        Session session = Session.getDefaultSession().withScale(scaleFactor).withParallelism(totalParts).withChunkNumber(partNumber + 1).withTable(table).withNoSexism(noSexism);
        Results results = Results.constructResults((Table)table, (Session)session);
        return new TpcdsRecordSet(results, (List<Column>)builder.build());
    }
}

