/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds.statistics;

import io.trino.plugin.tpcds.TpcdsColumnHandle;
import io.trino.plugin.tpcds.statistics.ColumnStatisticsData;
import io.trino.plugin.tpcds.statistics.TableStatisticsData;
import io.trino.plugin.tpcds.statistics.TableStatisticsDataRepository;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.tpcds.Table;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;

public class TpcdsTableStatisticsFactory {
    private final TableStatisticsDataRepository statisticsDataRepository = new TableStatisticsDataRepository();

    public TableStatistics create(String schemaName, Table table, Map<String, ColumnHandle> columnHandles) {
        Optional<TableStatisticsData> statisticsDataOptional = this.statisticsDataRepository.load(schemaName, table);
        return statisticsDataOptional.map(statisticsData -> this.toTableStatistics(columnHandles, (TableStatisticsData)statisticsData)).orElse(TableStatistics.empty());
    }

    private TableStatistics toTableStatistics(Map<String, ColumnHandle> columnHandles, TableStatisticsData statisticsData) {
        long rowCount = statisticsData.rowCount();
        TableStatistics.Builder tableStatistics = TableStatistics.builder().setRowCount(Estimate.of((double)rowCount));
        if (rowCount > 0L) {
            Map<String, ColumnStatisticsData> columnsData = statisticsData.columns();
            for (Map.Entry<String, ColumnHandle> entry : columnHandles.entrySet()) {
                TpcdsColumnHandle columnHandle = (TpcdsColumnHandle)entry.getValue();
                tableStatistics.setColumnStatistics(entry.getValue(), this.toColumnStatistics(columnsData.get(entry.getKey()), columnHandle.type(), rowCount));
            }
        }
        return tableStatistics.build();
    }

    private ColumnStatistics toColumnStatistics(ColumnStatisticsData columnStatisticsData, Type type, long rowCount) {
        ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
        long nullCount = columnStatisticsData.nullsCount();
        columnStatistics.setNullsFraction(Estimate.of((double)((double)nullCount / (double)rowCount)));
        columnStatistics.setRange(TpcdsTableStatisticsFactory.toRange(columnStatisticsData.min(), columnStatisticsData.max(), type));
        columnStatistics.setDistinctValuesCount(Estimate.of((double)columnStatisticsData.distinctValuesCount()));
        columnStatistics.setDataSize(columnStatisticsData.dataSize().map(Estimate::of).orElse(Estimate.unknown()));
        return columnStatistics.build();
    }

    private static Optional<DoubleRange> toRange(Optional<Object> min, Optional<Object> max, Type columnType) {
        if (columnType instanceof VarcharType || columnType instanceof CharType || columnType instanceof TimeType) {
            return Optional.empty();
        }
        if (min.isEmpty() || max.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DoubleRange(TpcdsTableStatisticsFactory.toDouble(min.get(), columnType), TpcdsTableStatisticsFactory.toDouble(max.get(), columnType)));
    }

    private static double toDouble(Object value, Type type) {
        if (value instanceof String) {
            String string = (String)value;
            if (type.equals((Object)DateType.DATE)) {
                return LocalDate.parse(string).toEpochDay();
            }
        }
        if (type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)DateType.DATE)) {
            return ((Number)value).doubleValue();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return Double.parseDouble(Decimals.toString((long)((Number)value).longValue(), (int)decimalType.getScale()));
            }
            return Double.parseDouble(Decimals.toString((Int128)((Int128)value), (int)decimalType.getScale()));
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException("unsupported column type " + String.valueOf(type));
    }
}

