/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.distribution;

import io.trino.tpcds.distribution.IntValuesDistribution;
import io.trino.tpcds.distribution.StringValuesDistribution;

public final class DemographicsDistributions {
    public static final StringValuesDistribution GENDER_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("genders.dst", 1, 1);
    public static final StringValuesDistribution MARITAL_STATUS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("marital_statuses.dst", 1, 1);
    public static final StringValuesDistribution EDUCATION_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("education.dst", 1, 4);
    public static final IntValuesDistribution PURCHASE_BAND_DISTRIBUTION = IntValuesDistribution.buildIntValuesDistribution("purchase_band.dst", 1, 1);
    public static final StringValuesDistribution CREDIT_RATING_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("credit_ratings.dst", 1, 1);
    public static final IntValuesDistribution INCOME_BAND_DISTRIBUTION = IntValuesDistribution.buildIntValuesDistribution("income_band.dst", 2, 1);
    public static final StringValuesDistribution BUY_POTENTIAL_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("buy_potential.dst", 1, 1);
    public static final IntValuesDistribution DEP_COUNT_DISTRIBUTION = IntValuesDistribution.buildIntValuesDistribution("dep_count.dst", 1, 1);
    public static final IntValuesDistribution VEHICLE_COUNT_DISTRIBUTION = IntValuesDistribution.buildIntValuesDistribution("vehicle_count.dst", 1, 1);

    private DemographicsDistributions() {
    }

    public static String getGenderForIndexModSize(long index) {
        return GENDER_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static String getMaritalStatusForIndexModSize(long index) {
        return MARITAL_STATUS_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static String getEducationForIndexModSize(long index) {
        return EDUCATION_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static Integer getPurchaseBandForIndexModSize(long index) {
        return PURCHASE_BAND_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static String getCreditRatingForIndexModSize(long index) {
        return CREDIT_RATING_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static String getBuyPotentialForIndexModSize(long index) {
        return BUY_POTENTIAL_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static Integer getDepCountForIndexModSize(long index) {
        return DEP_COUNT_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static Integer getVehicleCountForIndexModSize(long index) {
        return VEHICLE_COUNT_DISTRIBUTION.getValueForIndexModSize(index, 0);
    }

    public static Integer getIncomeBandLowerBoundAtIndex(int index) {
        return INCOME_BAND_DISTRIBUTION.getValueAtIndex(0, index);
    }

    public static Integer getIncomeBandUpperBoundAtIndex(int index) {
        return INCOME_BAND_DISTRIBUTION.getValueAtIndex(1, index);
    }
}

