/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.JoinKeyUtils;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.EnglishDistributions;
import io.trino.tpcds.generator.PromotionGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.PromotionRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Date;
import io.trino.tpcds.type.Decimal;

public class PromotionRowGenerator
extends AbstractRowGenerator {
    private static final int PROMO_START_MIN = -720;
    private static final int PROMO_START_MAX = 100;
    private static final int PROMO_LENGTH_MIN = 1;
    private static final int PROMO_LENGTH_MAX = 60;
    private static final int PROMO_NAME_LENGTH = 5;
    private static final int PROMO_DETAIL_LENGTH_MIN = 20;
    private static final int PROMO_DETAIL_LENGTH_MAX = 60;

    public PromotionRowGenerator() {
        super(Table.PROMOTION);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.PROMOTION, this.getRandomNumberStream(PromotionGeneratorColumn.P_NULLS));
        long pPromoSk = rowNumber;
        String pPromoId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        long pStartDateId = Date.JULIAN_DATE_MINIMUM + RandomValueGenerator.generateUniformRandomInt(-720, 100, this.getRandomNumberStream(PromotionGeneratorColumn.P_START_DATE_ID));
        long pEndDateId = pStartDateId + (long)RandomValueGenerator.generateUniformRandomInt(1, 60, this.getRandomNumberStream(PromotionGeneratorColumn.P_END_DATE_ID));
        long pItemSk = JoinKeyUtils.generateJoinKey(PromotionGeneratorColumn.P_ITEM_SK, this.getRandomNumberStream(PromotionGeneratorColumn.P_ITEM_SK), Table.ITEM, 1L, session.getScaling());
        Decimal pCost = new Decimal(100000L, 2);
        int pResponseTarget = 1;
        String pPromoName = RandomValueGenerator.generateWord(rowNumber, 5, EnglishDistributions.SYLLABLES_DISTRIBUTION);
        int flags = RandomValueGenerator.generateUniformRandomInt(0, 511, this.getRandomNumberStream(PromotionGeneratorColumn.P_CHANNEL_DMAIL));
        boolean pChannelDmail = (flags & 1) != 0;
        boolean pChannelEmail = ((flags <<= 1) & 1) != 0;
        boolean pChannelCatalog = ((flags <<= 1) & 1) != 0;
        boolean pChannelTv = ((flags <<= 1) & 1) != 0;
        boolean pChannelRadio = ((flags <<= 1) & 1) != 0;
        boolean pChannelPress = ((flags <<= 1) & 1) != 0;
        boolean pChannelEvent = ((flags <<= 1) & 1) != 0;
        boolean pChannelDemo = ((flags <<= 1) & 1) != 0;
        boolean pDiscountActive = ((flags <<= 1) & 1) != 0;
        String pChannelDetails = RandomValueGenerator.generateRandomText(20, 60, this.getRandomNumberStream(PromotionGeneratorColumn.P_CHANNEL_DETAILS));
        String pPurpose = "Unknown";
        return new RowGeneratorResult(new PromotionRow(nullBitMap, pPromoSk, pPromoId, pStartDateId, pEndDateId, pItemSk, pCost, pResponseTarget, pPromoName, pChannelDmail, pChannelEmail, pChannelCatalog, pChannelTv, pChannelRadio, pChannelPress, pChannelEvent, pChannelDemo, pChannelDetails, pPurpose, pDiscountActive));
    }
}

