/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.DemographicsDistributions;
import io.trino.tpcds.generator.CustomerDemographicsGeneratorColumn;
import io.trino.tpcds.row.CustomerDemographicsRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;

public class CustomerDemographicsRowGenerator
extends AbstractRowGenerator {
    private static final int MAX_CHILDREN = 7;
    private static final int MAX_EMPLOYED = 7;
    private static final int MAX_COLLEGE = 7;

    public CustomerDemographicsRowGenerator() {
        super(Table.CUSTOMER_DEMOGRAPHICS);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.CUSTOMER_DEMOGRAPHICS, this.getRandomNumberStream(CustomerDemographicsGeneratorColumn.CD_NULLS));
        long cDemoSk = rowNumber;
        long index = cDemoSk - 1L;
        String cdGender = DemographicsDistributions.getGenderForIndexModSize(index);
        String cdMaritalStatus = DemographicsDistributions.getMaritalStatusForIndexModSize(index /= (long)DemographicsDistributions.GENDER_DISTRIBUTION.getSize());
        String cdEducationStatus = DemographicsDistributions.getEducationForIndexModSize(index /= (long)DemographicsDistributions.MARITAL_STATUS_DISTRIBUTION.getSize());
        int cdPurchaseEstimate = DemographicsDistributions.getPurchaseBandForIndexModSize(index /= (long)DemographicsDistributions.EDUCATION_DISTRIBUTION.getSize());
        String cdCreditRating = DemographicsDistributions.getCreditRatingForIndexModSize(index /= (long)DemographicsDistributions.PURCHASE_BAND_DISTRIBUTION.getSize());
        int cdDepCount = (int)((index /= (long)DemographicsDistributions.CREDIT_RATING_DISTRIBUTION.getSize()) % 7L);
        int cdEmployedCount = (int)((index /= 7L) % 7L);
        int cdDepCollegeCount = (int)((index /= 7L) % 7L);
        return new RowGeneratorResult(new CustomerDemographicsRow(nullBitMap, cDemoSk, cdGender, cdMaritalStatus, cdEducationStatus, cdPurchaseEstimate, cdCreditRating, cdDepCount, cdEmployedCount, cdDepCollegeCount));
    }
}

