/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.base.MoreObjects;
import io.trino.plugin.tpch.ColumnNaming;
import io.trino.plugin.tpch.TpchHandleResolver;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.plugin.tpch.TpchNodePartitioningProvider;
import io.trino.plugin.tpch.TpchPageSourceProvider;
import io.trino.plugin.tpch.TpchRecordSetProvider;
import io.trino.plugin.tpch.TpchSplitManager;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class TpchConnectorFactory
implements ConnectorFactory {
    public static final String TPCH_COLUMN_NAMING_PROPERTY = "tpch.column-naming";
    public static final String TPCH_PRODUCE_PAGES = "tpch.produce-pages";
    public static final String TPCH_MAX_ROWS_PER_PAGE_PROPERTY = "tpch.max-rows-per-page";
    public static final String TPCH_TABLE_SCAN_REDIRECTION_CATALOG = "tpch.table-scan-redirection-catalog";
    public static final String TPCH_TABLE_SCAN_REDIRECTION_SCHEMA = "tpch.table-scan-redirection-schema";
    private static final int DEFAULT_MAX_ROWS_PER_PAGE = 1000000;
    private final int defaultSplitsPerNode;
    private final boolean predicatePushdownEnabled;
    private final boolean partitioningEnabled;

    public TpchConnectorFactory() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public TpchConnectorFactory(int defaultSplitsPerNode) {
        this(defaultSplitsPerNode, true, true);
    }

    public TpchConnectorFactory(int defaultSplitsPerNode, boolean predicatePushdownEnabled, boolean partitioningEnabled) {
        this.defaultSplitsPerNode = defaultSplitsPerNode;
        this.predicatePushdownEnabled = predicatePushdownEnabled;
        this.partitioningEnabled = partitioningEnabled;
    }

    public String getName() {
        return "tpch";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchHandleResolver();
    }

    public Connector create(String catalogName, final Map<String, String> properties, ConnectorContext context) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        final ColumnNaming columnNaming = ColumnNaming.valueOf(properties.getOrDefault(TPCH_COLUMN_NAMING_PROPERTY, ColumnNaming.SIMPLIFIED.name()).toUpperCase(Locale.ENGLISH));
        final NodeManager nodeManager = context.getNodeManager();
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new TpchMetadata(columnNaming, TpchConnectorFactory.this.predicatePushdownEnabled, TpchConnectorFactory.this.partitioningEnabled, TpchConnectorFactory.this.getTpchTableScanRedirectionCatalog(properties), TpchConnectorFactory.this.getTpchTableScanRedirectionSchema(properties));
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(nodeManager, splitsPerNode);
            }

            public ConnectorPageSourceProvider getPageSourceProvider() {
                if (TpchConnectorFactory.this.isProducePages(properties)) {
                    return new TpchPageSourceProvider(TpchConnectorFactory.this.getMaxRowsPerPage(properties));
                }
                throw new UnsupportedOperationException();
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                if (!TpchConnectorFactory.this.isProducePages(properties)) {
                    return new TpchRecordSetProvider();
                }
                throw new UnsupportedOperationException();
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }

    private boolean isProducePages(Map<String, String> properties) {
        return Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)properties.get(TPCH_PRODUCE_PAGES), (Object)Boolean.FALSE.toString()));
    }

    private int getMaxRowsPerPage(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get(TPCH_MAX_ROWS_PER_PAGE_PROPERTY), (Object)String.valueOf(1000000)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid property %s", TPCH_MAX_ROWS_PER_PAGE_PROPERTY));
        }
    }

    private Optional<String> getTpchTableScanRedirectionCatalog(Map<String, String> properties) {
        return Optional.ofNullable(properties.get(TPCH_TABLE_SCAN_REDIRECTION_CATALOG));
    }

    private Optional<String> getTpchTableScanRedirectionSchema(Map<String, String> properties) {
        return Optional.ofNullable(properties.get(TPCH_TABLE_SCAN_REDIRECTION_SCHEMA));
    }
}

