/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpch.TpchBucketFunction;
import io.trino.plugin.tpch.TpchPartitioningHandle;
import io.trino.plugin.tpch.TpchSplit;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;

public class TpchNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;
    private final int splitsPerNode;

    public TpchNodePartitioningProvider(NodeManager nodeManager, int splitsPerNode) {
        this.nodeManager = nodeManager;
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.splitsPerNode = splitsPerNode;
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        return ConnectorBucketNodeMap.createBucketNodeMap((int)Math.toIntExact((long)nodes.size() * (long)this.splitsPerNode));
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((TpchSplit)value).getPartNumber();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        long totalRows = ((TpchPartitioningHandle)partitioningHandle).getTotalRows();
        long rowsPerBucket = totalRows / (long)bucketCount;
        Preconditions.checkArgument((boolean)partitionChannelTypes.equals(ImmutableList.of((Object)BigintType.BIGINT)), (Object)"Expected one BIGINT parameter");
        return new TpchBucketFunction(bucketCount, rowsPerBucket);
    }
}

