/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

public class TpchTableHandle
implements ConnectorTableHandle {
    private final String tableName;
    private final double scaleFactor;
    private final TupleDomain<ColumnHandle> constraint;

    public TpchTableHandle(String tableName, double scaleFactor) {
        this(tableName, scaleFactor, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    @JsonCreator
    public TpchTableHandle(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="scaleFactor") double scaleFactor, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"Scale factor must be larger than 0");
        this.scaleFactor = scaleFactor;
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public String toString() {
        return this.tableName + ":sf" + this.scaleFactor;
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.scaleFactor, this.constraint);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TpchTableHandle other = (TpchTableHandle)obj;
        return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.scaleFactor, other.scaleFactor) && Objects.equals(this.constraint, other.constraint);
    }
}

