/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch.util;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.function.Predicate;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static Predicate<NullableValue> convertToPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        TupleDomain<ColumnHandle> columnPredicate = PredicateUtils.filterColumns(predicate, columnHandle::equals);
        return nullableValue -> columnPredicate.contains(TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)nullableValue)));
    }

    public static TupleDomain<ColumnHandle> filterOutColumnFromPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        return PredicateUtils.filterColumns(predicate, tpchColumnHandle -> !tpchColumnHandle.equals(columnHandle));
    }

    public static TupleDomain<ColumnHandle> filterColumns(TupleDomain<ColumnHandle> predicate, Predicate<TpchColumnHandle> filterPredicate) {
        return predicate.filter((columnHandle, domain) -> filterPredicate.test((TpchColumnHandle)columnHandle));
    }
}

