/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpch.TpchSplit;
import io.trino.spi.HostAddress;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Set;

public class TpchSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final int splitsPerNode;

    public TpchSplitManager(NodeManager nodeManager, int splitsPerNode) {
        this.nodeManager = nodeManager;
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.splitsPerNode = splitsPerNode;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        int totalParts = nodes.size() * this.splitsPerNode;
        int partNumber = 0;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node : nodes) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new TpchSplit(partNumber, totalParts, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort())));
                ++partNumber;
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

