/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.LazyRecordPageSource;
import io.trino.plugin.tpch.TpchRecordSetProvider;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import java.util.List;

public class TpchPageSourceProvider
implements ConnectorPageSourceProvider {
    private final TpchRecordSetProvider tpchRecordSetProvider;
    private final int maxRowsPerPage;

    TpchPageSourceProvider(int maxRowsPerPage, DecimalTypeMapping decimalTypeMapping) {
        this.tpchRecordSetProvider = new TpchRecordSetProvider(decimalTypeMapping);
        this.maxRowsPerPage = maxRowsPerPage;
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        return new LazyRecordPageSource(this.maxRowsPerPage, this.tpchRecordSetProvider.getRecordSet(transaction, session, split, table, columns));
    }
}

