/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch.util;

import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.util.function.Predicate;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static Predicate<NullableValue> convertToPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        Domain columnDomain = predicate.getDomains().map(domains -> domains.getOrDefault(columnHandle, Domain.all((Type)columnHandle.type()))).orElseGet(() -> Domain.none((Type)columnHandle.type()));
        return nullableValue -> columnDomain.includesNullableValue(nullableValue.getValue());
    }

    public static TupleDomain<ColumnHandle> filterOutColumnFromPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        return PredicateUtils.filterColumns(predicate, tpchColumnHandle -> !tpchColumnHandle.equals(columnHandle));
    }

    private static TupleDomain<ColumnHandle> filterColumns(TupleDomain<ColumnHandle> predicate, Predicate<TpchColumnHandle> filterPredicate) {
        return predicate.filter((columnHandle, domain) -> filterPredicate.test((TpchColumnHandle)columnHandle));
    }
}

