/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.inject.Inject;
import io.trino.plugin.tpch.TpchConfig;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;

public class TpchConnector
implements Connector {
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final ConnectorRecordSetProvider recordSetProvider;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final boolean producePages;

    @Inject
    public TpchConnector(ConnectorMetadata metadata, ConnectorSplitManager splitManager, ConnectorNodePartitioningProvider nodePartitioningProvider, ConnectorRecordSetProvider recordSetProvider, ConnectorPageSourceProvider pageSourceProvider, TpchConfig config) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.producePages = Objects.requireNonNull(config, "config is null").isProducePages();
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return TpchTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        if (this.producePages) {
            return this.pageSourceProvider;
        }
        throw new UnsupportedOperationException();
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        if (!this.producePages) {
            return this.recordSetProvider;
        }
        throw new UnsupportedOperationException();
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }
}

