/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.StringUtils;
import io.trino.tpch.TpchEntity;
import java.util.Objects;

public record Customer(long rowNumber, long customerKey, String name, String address, long nationKey, String phone, long accountBalanceInCents, String marketSegment, String comment) implements TpchEntity
{
    public Customer {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(address, "address is null");
        Objects.requireNonNull(phone, "phone is null");
        Objects.requireNonNull(marketSegment, "marketSegment is null");
        Objects.requireNonNull(comment, "comment is null");
    }

    public double accountBalance() {
        return (double)this.accountBalanceInCents / 100.0;
    }

    @Override
    public String toLine() {
        return StringUtils.buildLine(this.customerKey, this.name, this.address, this.nationKey, this.phone, GenerateUtils.formatMoney(this.accountBalanceInCents), this.marketSegment, this.comment);
    }
}

