/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.Customer;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchColumnType;
import io.trino.tpch.TpchColumnTypes;

public enum CustomerColumn implements TpchColumn<Customer>
{
    CUSTOMER_KEY("c_custkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Customer customer) {
            return customer.customerKey();
        }
    }
    ,
    NAME("c_name", TpchColumnTypes.varchar(25L)){

        @Override
        public String getString(Customer customer) {
            return customer.name();
        }
    }
    ,
    ADDRESS("c_address", TpchColumnTypes.varchar(40L)){

        @Override
        public String getString(Customer customer) {
            return customer.address();
        }
    }
    ,
    NATION_KEY("c_nationkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Customer customer) {
            return customer.nationKey();
        }
    }
    ,
    PHONE("c_phone", TpchColumnTypes.varchar(15L)){

        @Override
        public String getString(Customer customer) {
            return customer.phone();
        }
    }
    ,
    ACCOUNT_BALANCE("c_acctbal", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(Customer customer) {
            return customer.accountBalance();
        }

        @Override
        public long getIdentifier(Customer customer) {
            return customer.accountBalanceInCents();
        }
    }
    ,
    MARKET_SEGMENT("c_mktsegment", TpchColumnTypes.varchar(10L)){

        @Override
        public String getString(Customer customer) {
            return customer.marketSegment();
        }
    }
    ,
    COMMENT("c_comment", TpchColumnTypes.varchar(117L)){

        @Override
        public String getString(Customer customer) {
            return customer.comment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private CustomerColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(Customer entity) {
        throw new UnsupportedOperationException();
    }
}

