/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.StringUtils;
import io.trino.tpch.TpchEntity;
import java.util.Objects;

public record LineItem(long rowNumber, long orderKey, long partKey, long supplierKey, int lineNumber, long quantity, long extendedPriceInCents, long discountPercent, long taxPercent, String returnFlag, String status, int shipDate, int commitDate, int receiptDate, String shipInstructions, String shipMode, String comment) implements TpchEntity
{
    public LineItem {
        Objects.requireNonNull(returnFlag, "returnFlag is null");
        Objects.requireNonNull(status, "status is null");
        Objects.requireNonNull(shipInstructions, "shipInstructions is null");
        Objects.requireNonNull(shipMode, "shipMode is null");
        Objects.requireNonNull(comment, "comment is null");
    }

    public double extendedPrice() {
        return (double)this.extendedPriceInCents / 100.0;
    }

    public double discount() {
        return (double)this.discountPercent / 100.0;
    }

    public double tax() {
        return (double)this.taxPercent / 100.0;
    }

    @Override
    public String toLine() {
        return StringUtils.buildLine(this.orderKey, this.partKey, this.supplierKey, this.lineNumber, this.quantity, GenerateUtils.formatMoney(this.extendedPriceInCents), GenerateUtils.formatMoney(this.discountPercent), GenerateUtils.formatMoney(this.taxPercent), this.returnFlag, this.status, GenerateUtils.formatDate(this.shipDate), GenerateUtils.formatDate(this.commitDate), GenerateUtils.formatDate(this.receiptDate), this.shipInstructions, this.shipMode, this.comment);
    }
}

