/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.LineItem;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchColumnType;
import io.trino.tpch.TpchColumnTypes;

public enum LineItemColumn implements TpchColumn<LineItem>
{
    ORDER_KEY("l_orderkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.orderKey();
        }
    }
    ,
    PART_KEY("l_partkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.partKey();
        }
    }
    ,
    SUPPLIER_KEY("l_suppkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.supplierKey();
        }
    }
    ,
    LINE_NUMBER("l_linenumber", TpchColumnTypes.INTEGER){

        @Override
        public int getInteger(LineItem lineItem) {
            return lineItem.lineNumber();
        }
    }
    ,
    QUANTITY("l_quantity", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.quantity();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.quantity() * 100L;
        }
    }
    ,
    EXTENDED_PRICE("l_extendedprice", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.extendedPrice();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.extendedPriceInCents();
        }
    }
    ,
    DISCOUNT("l_discount", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.discount();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.discountPercent();
        }
    }
    ,
    TAX("l_tax", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.tax();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.taxPercent();
        }
    }
    ,
    RETURN_FLAG("l_returnflag", TpchColumnTypes.varchar(1L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.returnFlag();
        }
    }
    ,
    STATUS("l_linestatus", TpchColumnTypes.varchar(1L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.status();
        }
    }
    ,
    SHIP_DATE("l_shipdate", TpchColumnTypes.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.shipDate();
        }
    }
    ,
    COMMIT_DATE("l_commitdate", TpchColumnTypes.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.commitDate();
        }
    }
    ,
    RECEIPT_DATE("l_receiptdate", TpchColumnTypes.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.receiptDate();
        }
    }
    ,
    SHIP_INSTRUCTIONS("l_shipinstruct", TpchColumnTypes.varchar(25L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.shipInstructions();
        }
    }
    ,
    SHIP_MODE("l_shipmode", TpchColumnTypes.varchar(10L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.shipMode();
        }
    }
    ,
    COMMENT("l_comment", TpchColumnTypes.varchar(44L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.comment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private LineItemColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(LineItem entity) {
        throw new UnsupportedOperationException();
    }
}

