/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.StringUtils;
import io.trino.tpch.TpchEntity;
import java.util.Objects;

public record PartSupplier(long rowNumber, long partKey, long supplierKey, int availableQuantity, long supplyCostInCents, String comment) implements TpchEntity
{
    public PartSupplier {
        Objects.requireNonNull(comment, "comment is null");
    }

    public double getSupplyCost() {
        return (double)this.supplyCostInCents / 100.0;
    }

    @Override
    public String toLine() {
        return StringUtils.buildLine(this.partKey, this.supplierKey, this.availableQuantity, GenerateUtils.formatMoney(this.supplyCostInCents), this.comment);
    }
}

