/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.TextPool;
import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

final class SharingTextPoolSupplier
implements Supplier<TextPool> {
    private static final Logger log = Logger.getLogger(SharingTextPoolSupplier.class.getName());
    private final ScheduledExecutorService executor;
    private final Supplier<TextPool> loader;
    @GuardedBy(value="this")
    private SoftReference<TextPool> shared = new SoftReference<Object>(null);

    public SharingTextPoolSupplier(ScheduledExecutorService executor, Supplier<TextPool> loader) {
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    @Override
    public synchronized TextPool get() {
        TextPool textPool = this.shared.get();
        if (textPool == null) {
            TextPool newTextPool = this.loader.get();
            log.fine(() -> String.format("Loaded TextPool %s", Integer.toHexString(System.identityHashCode(newTextPool))));
            this.shared = new SoftReference<TextPool>(newTextPool);
            this.executor.schedule(() -> log.fine(() -> String.format("Releasing strong reference to TextPool %s", Integer.toHexString(System.identityHashCode(newTextPool)))), 10L, TimeUnit.SECONDS);
            textPool = newTextPool;
        }
        return textPool;
    }
}

