/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.base.Versions;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.tpch.TpchModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import org.weakref.jmx.guice.MBeanModule;

public class TpchConnectorFactory
implements ConnectorFactory {
    private final int defaultSplitsPerNode;
    private final boolean predicatePushdownEnabled;

    public TpchConnectorFactory() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public TpchConnectorFactory(int defaultSplitsPerNode) {
        this(defaultSplitsPerNode, true);
    }

    public TpchConnectorFactory(int defaultSplitsPerNode, boolean predicatePushdownEnabled) {
        this.defaultSplitsPerNode = defaultSplitsPerNode;
        this.predicatePushdownEnabled = predicatePushdownEnabled;
    }

    public String getName() {
        return "tpch";
    }

    public Connector create(String catalogName, Map<String, String> properties, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry()), new MBeanModule(), new JsonModule(), new TpchModule(context.getNodeManager(), this.defaultSplitsPerNode, this.predicatePushdownEnabled), new MBeanServerModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(properties).initialize();
        return (Connector)injector.getInstance(Connector.class);
    }
}

