/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.inject.Inject;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.LazyRecordPageSource;
import io.trino.plugin.tpch.TpchConfig;
import io.trino.plugin.tpch.TpchRecordSet;
import io.trino.plugin.tpch.TpchSplit;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Objects;

public class TpchPageSourceProvider
implements ConnectorPageSourceProvider {
    private final DecimalTypeMapping decimalTypeMapping;
    private final int maxRowsPerPage;

    @Inject
    TpchPageSourceProvider(TpchConfig config) {
        this(Objects.requireNonNull(config, "config is null").getMaxRowsPerPage(), config.getDecimalTypeMapping());
    }

    public TpchPageSourceProvider(int maxRowsPerPage, DecimalTypeMapping decimalTypeMapping) {
        this.decimalTypeMapping = Objects.requireNonNull(decimalTypeMapping, "decimalTypeMapping is null");
        this.maxRowsPerPage = maxRowsPerPage;
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        TpchSplit tpchSplit = (TpchSplit)split;
        TpchTableHandle tpchTable = (TpchTableHandle)table;
        return new LazyRecordPageSource(this.maxRowsPerPage, TpchRecordSet.getRecordSet(TpchTable.getTable((String)tpchTable.tableName()), columns, tpchTable.scaleFactor(), tpchSplit.getPartNumber(), tpchSplit.getTotalParts(), tpchTable.constraint(), this.decimalTypeMapping));
    }
}

