/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchColumnType;
import io.trino.tpch.TpchColumnTypes;
import io.trino.tpch.TpchEntity;
import io.trino.tpch.TpchTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TpchRecordSet<E extends TpchEntity>
implements RecordSet {
    private final Iterable<E> rows;
    private final TpchTable<E> table;
    private final List<TpchColumn<E>> columns;
    private final List<Type> columnTypes;
    private final TupleDomain<ColumnHandle> predicate;

    public static <E extends TpchEntity> RecordSet getRecordSet(TpchTable<E> table, List<? extends ColumnHandle> columns, double scaleFactor, int partNumber, int totalParts, TupleDomain<ColumnHandle> predicate, DecimalTypeMapping decimalTypeMapping) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = ((TpchColumnHandle)columnHandle).columnName();
            if (columnName.equalsIgnoreCase("row_number")) {
                builder.add(new RowNumberTpchColumn());
                continue;
            }
            builder.add((Object)table.getColumn(columnName));
        }
        return TpchRecordSet.createTpchRecordSet(table, builder.build(), decimalTypeMapping, scaleFactor, partNumber + 1, totalParts, predicate);
    }

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, double scaleFactor) {
        return TpchRecordSet.createTpchRecordSet(table, table.getColumns(), DecimalTypeMapping.DOUBLE, scaleFactor, 1, 1, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, DecimalTypeMapping decimalTypeMapping, double scaleFactor, int part, int partCount, TupleDomain<ColumnHandle> predicate) {
        return TpchRecordSet.createTpchRecordSet(table, table.getColumns(), decimalTypeMapping, scaleFactor, part, partCount, predicate);
    }

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, List<TpchColumn<E>> columns, DecimalTypeMapping decimalTypeMapping, double scaleFactor, int part, int partCount, TupleDomain<ColumnHandle> predicate) {
        return new TpchRecordSet<E>(table.createGenerator(scaleFactor, part, partCount), table, columns, decimalTypeMapping, predicate);
    }

    public TpchRecordSet(Iterable<E> rows, TpchTable<E> table, List<TpchColumn<E>> columns, DecimalTypeMapping decimalTypeMapping, TupleDomain<ColumnHandle> predicate) {
        this.rows = Objects.requireNonNull(rows, "rows is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.columnTypes = (List)columns.stream().map(column -> TpchMetadata.getTrinoType(column, decimalTypeMapping)).collect(ImmutableList.toImmutableList());
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new TpchRecordCursor<E>(this.rows.iterator(), this.table, this.columns, this.columnTypes, this.predicate);
    }

    private static class RowNumberTpchColumn<E extends TpchEntity>
    implements TpchColumn<E> {
        private RowNumberTpchColumn() {
        }

        public String getColumnName() {
            return "row_number";
        }

        public TpchColumnType getType() {
            return TpchColumnTypes.IDENTIFIER;
        }

        public double getDouble(E entity) {
            throw new UnsupportedOperationException();
        }

        public long getIdentifier(E entity) {
            return entity.rowNumber();
        }

        public int getInteger(E entity) {
            throw new UnsupportedOperationException();
        }

        public String getString(E entity) {
            throw new UnsupportedOperationException();
        }

        public int getDate(E entity) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class TpchRecordCursor<E extends TpchEntity>
    implements RecordCursor {
        private final Iterator<E> rows;
        private final TpchTable<E> table;
        private final List<TpchColumn<E>> columns;
        private final List<Type> columnTypes;
        private final TupleDomain<ColumnHandle> predicate;
        private E row;
        private boolean closed;

        public TpchRecordCursor(Iterator<E> rows, TpchTable<E> table, List<TpchColumn<E>> columns, List<Type> columnTypes, TupleDomain<ColumnHandle> predicate) {
            this.rows = Objects.requireNonNull(rows, "rows is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            this.columnTypes = Objects.requireNonNull(columnTypes, "columnTypes is null");
            this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.columnTypes.get(field);
        }

        public boolean advanceNextPosition() {
            while (!this.closed && this.rows.hasNext()) {
                this.row = (TpchEntity)this.rows.next();
                if (!this.rowMatchesPredicate()) continue;
                return true;
            }
            this.closed = true;
            this.row = null;
            return false;
        }

        public boolean getBoolean(int field) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getLong(this.getTpchColumn(field));
        }

        private long getLong(TpchColumn<E> tpchColumn) {
            if (tpchColumn.getType().getBase() == TpchColumnType.Base.DATE) {
                return tpchColumn.getDate(this.row);
            }
            if (tpchColumn.getType().getBase() == TpchColumnType.Base.INTEGER) {
                return tpchColumn.getInteger(this.row);
            }
            return tpchColumn.getIdentifier(this.row);
        }

        public double getDouble(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getDouble(this.getTpchColumn(field));
        }

        private double getDouble(TpchColumn<E> tpchColumn) {
            return tpchColumn.getDouble(this.row);
        }

        public Slice getSlice(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getSlice(this.getTpchColumn(field));
        }

        private Slice getSlice(TpchColumn<E> tpchColumn) {
            return Slices.utf8Slice((String)tpchColumn.getString(this.row));
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            return false;
        }

        public void close() {
            this.row = null;
            this.closed = true;
        }

        private boolean rowMatchesPredicate() {
            if (this.predicate.isAll()) {
                return true;
            }
            if (this.predicate.isNone()) {
                return false;
            }
            Map rowMap = (Map)((Map)this.predicate.getDomains().get()).keySet().stream().collect(ImmutableMap.toImmutableMap(column -> column, column -> {
                TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)column;
                Type type = tpchColumnHandle.type();
                TpchColumn tpchColumn = this.table.getColumn(tpchColumnHandle.columnName());
                return NullableValue.of((Type)type, (Object)this.getTrinoObject(tpchColumn, type));
            }));
            TupleDomain rowTupleDomain = TupleDomain.fromFixedValues((Map)rowMap);
            return this.predicate.contains(rowTupleDomain);
        }

        private Object getTrinoObject(TpchColumn<E> column, Type type) {
            if (type.getJavaType() == Long.TYPE) {
                return this.getLong(column);
            }
            if (type.getJavaType() == Double.TYPE) {
                return this.getDouble(column);
            }
            if (type.getJavaType() == Slice.class) {
                return this.getSlice(column);
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s", type.getDisplayName()));
        }

        private TpchColumn<E> getTpchColumn(int field) {
            return this.columns.get(field);
        }
    }
}

