/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.tpch.TpchConfig;
import io.trino.plugin.tpch.TpchConnector;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.plugin.tpch.TpchNodePartitioningProvider;
import io.trino.plugin.tpch.TpchPageSourceProvider;
import io.trino.plugin.tpch.TpchSplitManager;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import java.util.Objects;

public class TpchModule
extends AbstractConfigurationAwareModule {
    private final NodeManager nodeManager;
    private final int defaultSplitsPerNode;
    private final boolean predicatePushdownEnabled;

    public TpchModule(NodeManager nodeManager, int defaultSplitsPerNode, boolean predicatePushdownEnabled) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
        this.predicatePushdownEnabled = predicatePushdownEnabled;
    }

    protected void setup(Binder binder) {
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(Connector.class).to(TpchConnector.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).to(TpchMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(TpchPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(TpchSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(TpchNodePartitioningProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TpchConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(TpchConfig.class, config -> {
            config.setSplitsPerNode(this.defaultSplitsPerNode);
            config.setPredicatePushdownEnabled(this.predicatePushdownEnabled);
        });
    }
}

