/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

class TpchPageSource
implements ConnectorPageSource {
    private static final int ROWS_PER_REQUEST = 4096;
    private final int maxRowsPerPage;
    private final RecordCursor cursor;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private boolean closed;

    TpchPageSource(int maxRowsPerPage, RecordSet recordSet) {
        Objects.requireNonNull(recordSet, "recordSet is null");
        this.maxRowsPerPage = maxRowsPerPage;
        this.cursor = recordSet.cursor();
        this.types = ImmutableList.copyOf((Collection)recordSet.getColumnTypes());
        this.pageBuilder = new PageBuilder(this.types);
    }

    public long getCompletedBytes() {
        return this.cursor.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.cursor.getReadTimeNanos();
    }

    public long getMemoryUsage() {
        return this.cursor.getMemoryUsage() + this.pageBuilder.getRetainedSizeInBytes();
    }

    public void close() {
        this.closed = true;
        this.cursor.close();
    }

    public boolean isFinished() {
        return this.closed && this.pageBuilder.isEmpty();
    }

    public SourcePage getNextSourcePage() {
        if (!this.closed) {
            for (int i = 0; i < 4096 && !this.pageBuilder.isFull() && this.pageBuilder.getPositionCount() < this.maxRowsPerPage; ++i) {
                if (!this.cursor.advanceNextPosition()) {
                    this.closed = true;
                    break;
                }
                this.pageBuilder.declarePosition();
                for (int column = 0; column < this.types.size(); ++column) {
                    BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                    if (this.cursor.isNull(column)) {
                        output.appendNull();
                        continue;
                    }
                    Type type = this.types.get(column);
                    Class javaType = type.getJavaType();
                    if (javaType == Boolean.TYPE) {
                        type.writeBoolean(output, this.cursor.getBoolean(column));
                        continue;
                    }
                    if (javaType == Long.TYPE) {
                        type.writeLong(output, this.cursor.getLong(column));
                        continue;
                    }
                    if (javaType == Double.TYPE) {
                        type.writeDouble(output, this.cursor.getDouble(column));
                        continue;
                    }
                    if (javaType == Slice.class) {
                        Slice slice = this.cursor.getSlice(column);
                        type.writeSlice(output, slice, 0, slice.length());
                        continue;
                    }
                    type.writeObject(output, this.cursor.getObject(column));
                }
            }
        }
        if (this.closed && !this.pageBuilder.isEmpty() || this.pageBuilder.isFull() || this.pageBuilder.getPositionCount() >= this.maxRowsPerPage) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return new TpchSourcePage(page);
        }
        return null;
    }

    private static class TpchSourcePage
    implements SourcePage {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(TpchSourcePage.class);
        private Page page;
        private final boolean[] loaded;
        private long sizeInBytes;

        public TpchSourcePage(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.loaded = new boolean[page.getChannelCount()];
        }

        public int getPositionCount() {
            return this.page.getPositionCount();
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.loaded) + this.page.getRetainedSizeInBytes();
        }

        public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
            consumer.accept(this, INSTANCE_SIZE);
            consumer.accept(this.loaded, SizeOf.sizeOf((boolean[])this.loaded));
            consumer.accept(this.page, Page.getInstanceSizeInBytes((int)this.page.getChannelCount()));
            for (int i = 0; i < this.page.getChannelCount(); ++i) {
                this.page.getBlock(i).retainedBytesForEachPart(consumer);
            }
        }

        public int getChannelCount() {
            return this.page.getChannelCount();
        }

        public Block getBlock(int channel) {
            Block block = this.page.getBlock(channel);
            if (!this.loaded[channel]) {
                this.loaded[channel] = true;
                this.sizeInBytes += block.getSizeInBytes();
            }
            return block;
        }

        public Page getPage() {
            return this.page;
        }

        public void selectPositions(int[] positions, int offset, int size) {
            this.page = this.page.getPositions(positions, offset, size);
        }
    }
}

