/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.vertica;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.vertica.VerticaTableStatisticsReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;

public class VerticaClient
extends BaseJdbcClient {
    private static final DateTimeFormatter DATE_READ_FORMATTER = DateTimeFormatter.ofPattern("u-MM-dd");
    private static final DateTimeFormatter DATE_WRITE_FORMATTER = new DateTimeFormatterBuilder().appendValueReduced((TemporalField)ChronoField.YEAR, 4, 7, 1000).appendPattern("-MM-dd[ G]").toFormatter();
    private final boolean statisticsEnabled;
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter;

    @Inject
    public VerticaClient(BaseJdbcConfig config, JdbcStatisticsConfig statisticsConfig, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, false);
        this.statisticsEnabled = Objects.requireNonNull(statisticsConfig, "statisticsConfig is null").isEnabled();
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((VerticaClient)this).quoted(arg_0)).withTypeClass("supported_type", (Set)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint", (Object)"decimal", (Object)"real", (Object[])new String[]{"char", "varchar"})).map("$equal(left: supported_type, right: supported_type)").to("left = right").map("$not_equal(left: supported_type, right: supported_type)").to("left <> right").map("$less_than(left: supported_type, right: supported_type)").to("left < right").map("$less_than_or_equal(left: supported_type, right: supported_type)").to("left <= right").map("$greater_than(left: supported_type, right: supported_type)").to("left > right").map("$greater_than_or_equal(left: supported_type, right: supported_type)").to("left >= right").build();
    }

    public Optional<String> getTableComment(ResultSet resultSet) {
        return Optional.empty();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        TableStatistics tableStatistics;
        block10: {
            if (!this.statisticsEnabled) {
                return TableStatistics.empty();
            }
            if (!handle.isNamedRelation()) {
                return TableStatistics.empty();
            }
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                tableStatistics = VerticaTableStatisticsReader.readTableStatistics(connection, handle, () -> JdbcMetadata.getColumns((ConnectorSession)session, (JdbcClient)this, (JdbcTableHandle)handle));
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException | SQLException e) {
                    Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed fetching statistics for table: " + String.valueOf(handle), (Throwable)e);
                }
            }
            connection.close();
        }
        return tableStatistics;
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql, Optional<Integer> columnCount) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mappingToVarchar = this.getForcedMappingToVarchar(typeHandle);
        if (mappingToVarchar.isPresent()) {
            return mappingToVarchar;
        }
        switch (typeHandle.jdbcType()) {
            case -7: 
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 6: 
            case 7: 
            case 8: {
                return Optional.of(ColumnMapping.doubleMapping((Type)DoubleType.DOUBLE, ResultSet::getDouble, (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 2: {
                int decimalDigits = typeHandle.requiredDecimalDigits();
                int precision = typeHandle.requiredColumnSize() + Math.max(-decimalDigits, 0);
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if (precision > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case 1: {
                return Optional.of(StandardColumnMappings.charColumnMapping((CharType)CharType.createCharType((int)typeHandle.requiredColumnSize()), (boolean)true));
            }
            case -1: 
            case 12: {
                return Optional.of(StandardColumnMappings.varcharColumnMapping((VarcharType)VarcharType.createVarcharType((int)typeHandle.requiredColumnSize()), (boolean)true));
            }
            case -4: 
            case -3: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (resultSet, index) -> LocalDate.parse(resultSet.getString(index), DATE_READ_FORMATTER).toEpochDay(), (LongWriteFunction)VerticaClient.dateWriteFunctionUsingString()));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return VerticaClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int length = charType.getLength();
            Preconditions.checkArgument((length <= 65000 ? 1 : 0) != 0, (Object)"Char length is greater than 65,000");
            return WriteMapping.sliceMapping((String)("char(" + length + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            Object dataType;
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                dataType = "long varchar";
            } else if (varcharType.getBoundedLength() <= 65000) {
                dataType = "varchar(" + varcharType.getBoundedLength() + ")";
            } else {
                Preconditions.checkArgument((varcharType.getBoundedLength() <= 32000000 ? 1 : 0) != 0, (Object)"Varchar length is greater than 32,000,000");
                dataType = "long varchar(" + varcharType.getBoundedLength() + ")";
            }
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"long varbinary", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)VerticaClient.dateWriteFunctionUsingString());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    private static LongWriteFunction dateWriteFunctionUsingString() {
        return (statement, index, day) -> statement.setString(index, DATE_WRITE_FORMATTER.format(LocalDate.ofEpochDay(day)));
    }

    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping columns");
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to delete from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to delete when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to delete when sort order is set: %s", (Object)handle);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareDeleteQuery((JdbcClient)this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), Optional.empty());
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement((JdbcClient)this, session, connection, preparedQuery, Optional.empty());
                try {
                    int affectedRowsCount = preparedStatement.executeUpdate();
                    connection.commit();
                    optionalLong = OptionalLong.of(affectedRowsCount);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to update from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to update when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to update when sort order is set: %s", (Object)handle);
        Preconditions.checkArgument((!handle.getUpdateAssignments().isEmpty() ? 1 : 0) != 0, (String)"Unable to update when update assignments are not set: %s", (Object)handle);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareUpdateQuery((JdbcClient)this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), VerticaClient.getAdditionalPredicate((List)handle.getConstraintExpressions(), Optional.empty()), handle.getUpdateAssignments());
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement((JdbcClient)this, session, connection, preparedQuery, Optional.empty());
                try {
                    int affectedRows = preparedStatement.executeUpdate();
                    connection.commit();
                    optionalLong = OptionalLong.of(affectedRows);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String newTableName = newTable.getTableName();
            if (connection.getMetaData().storesUpperCaseIdentifiers()) {
                newTableName = newTableName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(newTableName));
            this.execute(session, connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        return !joinCondition.getOperator().equals((Object)JoinCondition.Operator.IDENTICAL);
    }

    public OptionalInt getMaxColumnNameLength(ConnectorSession session) {
        return this.getMaxColumnNameLengthFromDatabaseMetaData(session);
    }
}

