/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.exceptions;

import java.util.Locale;

public class ExceptionUtilities {
    public static Locale createLocale(String locale) {
        if (null == locale) {
            return Locale.getDefault();
        }
        int indexOfHyphen = locale.indexOf("-");
        if (-1 == indexOfHyphen) {
            return new Locale(locale);
        }
        try {
            return new Locale(locale.substring(0, indexOfHyphen), locale.substring(indexOfHyphen + 1, indexOfHyphen + 3));
        }
        catch (IndexOutOfBoundsException e) {
            return Locale.getDefault();
        }
    }

    public static String localeToString(Locale locale) {
        String language = locale.getLanguage();
        if ("".equals(language)) {
            return "en-US";
        }
        String country = locale.getCountry();
        if ("".equals(country)) {
            return language;
        }
        return language + "-" + country;
    }

    public static String getPackageName(Class<?> clazz) {
        int classNameIndex;
        String result = "";
        String className = clazz.getCanonicalName();
        if (null != className && -1 != (classNameIndex = className.lastIndexOf("."))) {
            result = className.substring(0, className.lastIndexOf("."));
        }
        return result;
    }
}

