/*
 * Decompiled with CFR 0.152.
 */
package io.tus.java.client;

import java.io.IOException;
import java.net.HttpURLConnection;

public class ProtocolException
extends Exception {
    private HttpURLConnection connection;

    public ProtocolException(String message) {
        super(message);
    }

    public ProtocolException(String message, HttpURLConnection connection) {
        super(message);
        this.connection = connection;
    }

    public HttpURLConnection getCausingConnection() {
        return this.connection;
    }

    public boolean shouldRetry() {
        if (this.connection == null) {
            return false;
        }
        try {
            int responseCode = this.connection.getResponseCode();
            return responseCode >= 500 && responseCode < 600 || responseCode == 423;
        }
        catch (IOException e) {
            return false;
        }
    }
}

