/*
 * Decompiled with CFR 0.152.
 */
package io.tus.java.client;

import io.tus.java.client.FingerprintNotFoundException;
import io.tus.java.client.ProtocolException;
import io.tus.java.client.ResumingNotEnabledException;
import io.tus.java.client.TusURLStore;
import io.tus.java.client.TusUpload;
import io.tus.java.client.TusUploader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TusClient {
    public static final String TUS_VERSION = "1.0.0";
    private URL uploadCreationURL;
    private boolean resumingEnabled;
    private boolean removeFingerprintOnSuccessEnabled;
    private TusURLStore urlStore;
    private Map<String, String> headers;
    private int connectTimeout = 5000;

    public void setUploadCreationURL(URL uploadCreationURL) {
        this.uploadCreationURL = uploadCreationURL;
    }

    public URL getUploadCreationURL() {
        return this.uploadCreationURL;
    }

    public void enableResuming(@NotNull TusURLStore urlStore) {
        this.resumingEnabled = true;
        this.urlStore = urlStore;
    }

    public void disableResuming() {
        this.resumingEnabled = false;
        this.urlStore = null;
    }

    public boolean resumingEnabled() {
        return this.resumingEnabled;
    }

    public void enableRemoveFingerprintOnSuccess() {
        this.removeFingerprintOnSuccessEnabled = true;
    }

    public void disableRemoveFingerprintOnSuccess() {
        this.removeFingerprintOnSuccessEnabled = false;
    }

    public boolean removeFingerprintOnSuccessEnabled() {
        return this.removeFingerprintOnSuccessEnabled;
    }

    public void setHeaders(@Nullable Map<String, String> headers) {
        this.headers = headers;
    }

    @Nullable
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public TusUploader createUpload(@NotNull TusUpload upload) throws ProtocolException, IOException {
        HttpURLConnection connection = (HttpURLConnection)this.uploadCreationURL.openConnection();
        connection.setRequestMethod("POST");
        this.prepareConnection(connection);
        String encodedMetadata = upload.getEncodedMetadata();
        if (encodedMetadata.length() > 0) {
            connection.setRequestProperty("Upload-Metadata", encodedMetadata);
        }
        connection.addRequestProperty("Upload-Length", Long.toString(upload.getSize()));
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            throw new ProtocolException("unexpected status code (" + responseCode + ") while creating upload", connection);
        }
        String urlStr = connection.getHeaderField("Location");
        if (urlStr == null || urlStr.length() == 0) {
            throw new ProtocolException("missing upload URL in response for creating upload", connection);
        }
        URL uploadURL = new URL(connection.getURL(), urlStr);
        if (this.resumingEnabled) {
            this.urlStore.set(upload.getFingerprint(), uploadURL);
        }
        return new TusUploader(this, upload, uploadURL, upload.getTusInputStream(), 0L);
    }

    public TusUploader resumeUpload(@NotNull TusUpload upload) throws FingerprintNotFoundException, ResumingNotEnabledException, ProtocolException, IOException {
        if (!this.resumingEnabled) {
            throw new ResumingNotEnabledException();
        }
        URL uploadURL = this.urlStore.get(upload.getFingerprint());
        if (uploadURL == null) {
            throw new FingerprintNotFoundException(upload.getFingerprint());
        }
        return this.beginOrResumeUploadFromURL(upload, uploadURL);
    }

    public TusUploader beginOrResumeUploadFromURL(@NotNull TusUpload upload, @NotNull URL uploadURL) throws ProtocolException, IOException {
        HttpURLConnection connection = (HttpURLConnection)uploadURL.openConnection();
        connection.setRequestMethod("HEAD");
        this.prepareConnection(connection);
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            throw new ProtocolException("unexpected status code (" + responseCode + ") while resuming upload", connection);
        }
        String offsetStr = connection.getHeaderField("Upload-Offset");
        if (offsetStr == null || offsetStr.length() == 0) {
            throw new ProtocolException("missing upload offset in response for resuming upload", connection);
        }
        long offset = Long.parseLong(offsetStr);
        return new TusUploader(this, upload, uploadURL, upload.getTusInputStream(), offset);
    }

    public TusUploader resumeOrCreateUpload(@NotNull TusUpload upload) throws ProtocolException, IOException {
        try {
            return this.resumeUpload(upload);
        }
        catch (FingerprintNotFoundException e) {
            return this.createUpload(upload);
        }
        catch (ResumingNotEnabledException e) {
            return this.createUpload(upload);
        }
        catch (ProtocolException e) {
            HttpURLConnection connection = e.getCausingConnection();
            if (connection != null && connection.getResponseCode() == 404) {
                return this.createUpload(upload);
            }
            throw e;
        }
    }

    public void prepareConnection(@NotNull HttpURLConnection connection) {
        connection.setInstanceFollowRedirects(Boolean.getBoolean("http.strictPostRedirect"));
        connection.setConnectTimeout(this.connectTimeout);
        connection.addRequestProperty("Tus-Resumable", TUS_VERSION);
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void uploadFinished(@NotNull TusUpload upload) {
        if (this.resumingEnabled && this.removeFingerprintOnSuccessEnabled) {
            this.urlStore.remove(upload.getFingerprint());
        }
    }
}

