package io.udash.bootstrap.utils

import io.udash.css.{CssStyle, CssStyleName, CssStyleNameWithSharedCompanion}

object UdashIcons {
  object FontAwesome {
    def fab(suffix: String): CssStyle = CssStyleNameWithSharedCompanion("fab", "fa", s"fa-$suffix")
    def far(suffix: String): CssStyle = CssStyleNameWithSharedCompanion("far", "fa", s"fa-$suffix")
    def fas(suffix: String): CssStyle = CssStyleNameWithSharedCompanion("fas", "fa", s"fa-$suffix")
    def fal(suffix: String): CssStyle = CssStyleNameWithSharedCompanion("fal", "fa", s"fa-$suffix")

    object Modifiers {
      def border: CssStyle = CssStyleName("fa-border")
      def fixedWidth: CssStyle = CssStyleName("fa-fw")
      def inverse: CssStyle = CssStyleName("fa-inverse")
      def pullLeft: CssStyle = CssStyleName("fa-pull-left")
      def pullRight: CssStyle = CssStyleName("fa-pull-right")

      def ul: CssStyle = CssStyleName("fa-ul")
      def li: CssStyle = CssStyleName("fa-li")

      object Animation {
        def spin: CssStyle = CssStyleName("fa-spin")
        def pulse: CssStyle = CssStyleName("fa-pulse")
      }

      object Rotation {
        def rotate90: CssStyle = CssStyleName("fa-rotate-90")
        def rotate180: CssStyle = CssStyleName("fa-rotate-180")
        def rotate270: CssStyle = CssStyleName("fa-rotate-270")

        def flipHorizontal: CssStyle = CssStyleName("fa-flip-horizontal")
        def flipVertical: CssStyle = CssStyleName("fa-flip-vertical")
        def flipBoth: CssStyle = CssStyleName("fa-flip-both")
      }

      object Sizing {
        def xs: CssStyle = CssStyleName("fa-xs")
        def sm: CssStyle = CssStyleName("fa-sm")
        def lg: CssStyle = CssStyleName("fa-lg")
        def x1: CssStyle = CssStyleName("fa-1x")
        def x2: CssStyle = CssStyleName("fa-2x")
        def x3: CssStyle = CssStyleName("fa-3x")
        def x4: CssStyle = CssStyleName("fa-4x")
        def x5: CssStyle = CssStyleName("fa-5x")
        def x6: CssStyle = CssStyleName("fa-6x")
        def x7: CssStyle = CssStyleName("fa-7x")
        def x8: CssStyle = CssStyleName("fa-8x")
        def x9: CssStyle = CssStyleName("fa-9x")
        def x10: CssStyle = CssStyleName("fa-10x")
      }

      object Stack {
        def stack: CssStyle = CssStyleName("fa-stack")
        def stack1x: CssStyle = CssStyleName("fa-stack-1x")
        def stack2x: CssStyle = CssStyleName("fa-stack-2x")
      }
    }

    object Brands {
      def `500px`: CssStyle = fab("500px")
      def accessibleIcon: CssStyle = fab("accessible-icon")
      def accusoft: CssStyle = fab("accusoft")
      def acquisitionsIncorporated: CssStyle = fab("acquisitions-incorporated")
      def adn: CssStyle = fab("adn")
      def adobe: CssStyle = fab("adobe")
      def adversal: CssStyle = fab("adversal")
      def affiliatetheme: CssStyle = fab("affiliatetheme")
      def airbnb: CssStyle = fab("airbnb")
      def algolia: CssStyle = fab("algolia")
      def alipay: CssStyle = fab("alipay")
      def amazon: CssStyle = fab("amazon")
      def amazonPay: CssStyle = fab("amazon-pay")
      def amilia: CssStyle = fab("amilia")
      def android: CssStyle = fab("android")
      def angellist: CssStyle = fab("angellist")
      def angrycreative: CssStyle = fab("angrycreative")
      def angular: CssStyle = fab("angular")
      def appStore: CssStyle = fab("app-store")
      def appStoreIos: CssStyle = fab("app-store-ios")
      def apper: CssStyle = fab("apper")
      def apple: CssStyle = fab("apple")
      def applePay: CssStyle = fab("apple-pay")
      def artstation: CssStyle = fab("artstation")
      def asymmetrik: CssStyle = fab("asymmetrik")
      def atlassian: CssStyle = fab("atlassian")
      def audible: CssStyle = fab("audible")
      def autoprefixer: CssStyle = fab("autoprefixer")
      def avianex: CssStyle = fab("avianex")
      def aviato: CssStyle = fab("aviato")
      def aws: CssStyle = fab("aws")
      def bandcamp: CssStyle = fab("bandcamp")
      def battleNet: CssStyle = fab("battle-net")
      def behance: CssStyle = fab("behance")
      def behanceSquare: CssStyle = fab("behance-square")
      def bimobject: CssStyle = fab("bimobject")
      def bitbucket: CssStyle = fab("bitbucket")
      def bitcoin: CssStyle = fab("bitcoin")
      def bity: CssStyle = fab("bity")
      def blackTie: CssStyle = fab("black-tie")
      def blackberry: CssStyle = fab("blackberry")
      def blogger: CssStyle = fab("blogger")
      def bloggerB: CssStyle = fab("blogger-b")
      def bluetooth: CssStyle = fab("bluetooth")
      def bluetoothB: CssStyle = fab("bluetooth-b")
      def bootstrap: CssStyle = fab("bootstrap")
      def btc: CssStyle = fab("btc")
      def buffer: CssStyle = fab("buffer")
      def buromobelexperte: CssStyle = fab("buromobelexperte")
      def buysellads: CssStyle = fab("buysellads")
      def canadianMapleLeaf: CssStyle = fab("canadian-maple-leaf")
      def ccAmazonPay: CssStyle = fab("cc-amazon-pay")
      def ccAmex: CssStyle = fab("cc-amex")
      def ccApplePay: CssStyle = fab("cc-apple-pay")
      def ccDinersClub: CssStyle = fab("cc-diners-club")
      def ccDiscover: CssStyle = fab("cc-discover")
      def ccJcb: CssStyle = fab("cc-jcb")
      def ccMastercard: CssStyle = fab("cc-mastercard")
      def ccPaypal: CssStyle = fab("cc-paypal")
      def ccStripe: CssStyle = fab("cc-stripe")
      def ccVisa: CssStyle = fab("cc-visa")
      def centercode: CssStyle = fab("centercode")
      def centos: CssStyle = fab("centos")
      def chrome: CssStyle = fab("chrome")
      def chromecast: CssStyle = fab("chromecast")
      def cloudscale: CssStyle = fab("cloudscale")
      def cloudsmith: CssStyle = fab("cloudsmith")
      def cloudversify: CssStyle = fab("cloudversify")
      def codepen: CssStyle = fab("codepen")
      def codiepie: CssStyle = fab("codiepie")
      def confluence: CssStyle = fab("confluence")
      def connectdevelop: CssStyle = fab("connectdevelop")
      def contao: CssStyle = fab("contao")
      def cottonBureau: CssStyle = fab("cotton-bureau")
      def cpanel: CssStyle = fab("cpanel")
      def creativeCommons: CssStyle = fab("creative-commons")
      def creativeCommonsBy: CssStyle = fab("creative-commons-by")
      def creativeCommonsNc: CssStyle = fab("creative-commons-nc")
      def creativeCommonsNcEu: CssStyle = fab("creative-commons-nc-eu")
      def creativeCommonsNcJp: CssStyle = fab("creative-commons-nc-jp")
      def creativeCommonsNd: CssStyle = fab("creative-commons-nd")
      def creativeCommonsPd: CssStyle = fab("creative-commons-pd")
      def creativeCommonsPdAlt: CssStyle = fab("creative-commons-pd-alt")
      def creativeCommonsRemix: CssStyle = fab("creative-commons-remix")
      def creativeCommonsSa: CssStyle = fab("creative-commons-sa")
      def creativeCommonsSampling: CssStyle = fab("creative-commons-sampling")
      def creativeCommonsSamplingPlus: CssStyle = fab("creative-commons-sampling-plus")
      def creativeCommonsShare: CssStyle = fab("creative-commons-share")
      def creativeCommonsZero: CssStyle = fab("creative-commons-zero")
      def criticalRole: CssStyle = fab("critical-role")
      def css3: CssStyle = fab("css3")
      def css3Alt: CssStyle = fab("css3-alt")
      def cuttlefish: CssStyle = fab("cuttlefish")
      def dAndD: CssStyle = fab("d-and-d")
      def dAndDBeyond: CssStyle = fab("d-and-d-beyond")
      def dashcube: CssStyle = fab("dashcube")
      def delicious: CssStyle = fab("delicious")
      def deploydog: CssStyle = fab("deploydog")
      def deskpro: CssStyle = fab("deskpro")
      def dev: CssStyle = fab("dev")
      def deviantart: CssStyle = fab("deviantart")
      def dhl: CssStyle = fab("dhl")
      def diaspora: CssStyle = fab("diaspora")
      def digg: CssStyle = fab("digg")
      def digitalOcean: CssStyle = fab("digital-ocean")
      def discord: CssStyle = fab("discord")
      def discourse: CssStyle = fab("discourse")
      def dochub: CssStyle = fab("dochub")
      def docker: CssStyle = fab("docker")
      def draft2digital: CssStyle = fab("draft2digital")
      def dribbble: CssStyle = fab("dribbble")
      def dribbbleSquare: CssStyle = fab("dribbble-square")
      def dropbox: CssStyle = fab("dropbox")
      def drupal: CssStyle = fab("drupal")
      def dyalog: CssStyle = fab("dyalog")
      def earlybirds: CssStyle = fab("earlybirds")
      def ebay: CssStyle = fab("ebay")
      def edge: CssStyle = fab("edge")
      def elementor: CssStyle = fab("elementor")
      def ello: CssStyle = fab("ello")
      def ember: CssStyle = fab("ember")
      def empire: CssStyle = fab("empire")
      def envira: CssStyle = fab("envira")
      def erlang: CssStyle = fab("erlang")
      def ethereum: CssStyle = fab("ethereum")
      def etsy: CssStyle = fab("etsy")
      def evernote: CssStyle = fab("evernote")
      def expeditedssl: CssStyle = fab("expeditedssl")
      def facebook: CssStyle = fab("facebook")
      def facebookF: CssStyle = fab("facebook-f")
      def facebookMessenger: CssStyle = fab("facebook-messenger")
      def facebookSquare: CssStyle = fab("facebook-square")
      def fantasyFlightGames: CssStyle = fab("fantasy-flight-games")
      def fedex: CssStyle = fab("fedex")
      def fedora: CssStyle = fab("fedora")
      def figma: CssStyle = fab("figma")
      def firefox: CssStyle = fab("firefox")
      def firstOrder: CssStyle = fab("first-order")
      def firstOrderAlt: CssStyle = fab("first-order-alt")
      def firstdraft: CssStyle = fab("firstdraft")
      def flickr: CssStyle = fab("flickr")
      def flipboard: CssStyle = fab("flipboard")
      def fly: CssStyle = fab("fly")
      def fontAwesome: CssStyle = fab("font-awesome")
      def fontAwesomeAlt: CssStyle = fab("font-awesome-alt")
      def fontAwesomeFlag: CssStyle = fab("font-awesome-flag")
      def fonticons: CssStyle = fab("fonticons")
      def fonticonsFi: CssStyle = fab("fonticons-fi")
      def fortAwesome: CssStyle = fab("fort-awesome")
      def fortAwesomeAlt: CssStyle = fab("fort-awesome-alt")
      def forumbee: CssStyle = fab("forumbee")
      def foursquare: CssStyle = fab("foursquare")
      def freeCodeCamp: CssStyle = fab("free-code-camp")
      def freebsd: CssStyle = fab("freebsd")
      def fulcrum: CssStyle = fab("fulcrum")
      def galacticRepublic: CssStyle = fab("galactic-republic")
      def galacticSenate: CssStyle = fab("galactic-senate")
      def getPocket: CssStyle = fab("get-pocket")
      def gg: CssStyle = fab("gg")
      def ggCircle: CssStyle = fab("gg-circle")
      def git: CssStyle = fab("git")
      def gitAlt: CssStyle = fab("git-alt")
      def gitSquare: CssStyle = fab("git-square")
      def github: CssStyle = fab("github")
      def githubAlt: CssStyle = fab("github-alt")
      def githubSquare: CssStyle = fab("github-square")
      def gitkraken: CssStyle = fab("gitkraken")
      def gitlab: CssStyle = fab("gitlab")
      def gitter: CssStyle = fab("gitter")
      def glide: CssStyle = fab("glide")
      def glideG: CssStyle = fab("glide-g")
      def gofore: CssStyle = fab("gofore")
      def goodreads: CssStyle = fab("goodreads")
      def goodreadsG: CssStyle = fab("goodreads-g")
      def google: CssStyle = fab("google")
      def googleDrive: CssStyle = fab("google-drive")
      def googlePlay: CssStyle = fab("google-play")
      def googlePlus: CssStyle = fab("google-plus")
      def googlePlusG: CssStyle = fab("google-plus-g")
      def googlePlusSquare: CssStyle = fab("google-plus-square")
      def googleWallet: CssStyle = fab("google-wallet")
      def gratipay: CssStyle = fab("gratipay")
      def grav: CssStyle = fab("grav")
      def gripfire: CssStyle = fab("gripfire")
      def grunt: CssStyle = fab("grunt")
      def gulp: CssStyle = fab("gulp")
      def hackerNews: CssStyle = fab("hacker-news")
      def hackerNewsSquare: CssStyle = fab("hacker-news-square")
      def hackerrank: CssStyle = fab("hackerrank")
      def hips: CssStyle = fab("hips")
      def hireAHelper: CssStyle = fab("hire-a-helper")
      def hooli: CssStyle = fab("hooli")
      def hornbill: CssStyle = fab("hornbill")
      def hotjar: CssStyle = fab("hotjar")
      def houzz: CssStyle = fab("houzz")
      def html5: CssStyle = fab("html5")
      def hubspot: CssStyle = fab("hubspot")
      def imdb: CssStyle = fab("imdb")
      def instagram: CssStyle = fab("instagram")
      def intercom: CssStyle = fab("intercom")
      def internetExplorer: CssStyle = fab("internet-explorer")
      def invision: CssStyle = fab("invision")
      def ioxhost: CssStyle = fab("ioxhost")
      def itchIo: CssStyle = fab("itch-io")
      def itunes: CssStyle = fab("itunes")
      def itunesNote: CssStyle = fab("itunes-note")
      def java: CssStyle = fab("java")
      def jediOrder: CssStyle = fab("jedi-order")
      def jenkins: CssStyle = fab("jenkins")
      def jira: CssStyle = fab("jira")
      def joget: CssStyle = fab("joget")
      def joomla: CssStyle = fab("joomla")
      def js: CssStyle = fab("js")
      def jsSquare: CssStyle = fab("js-square")
      def jsfiddle: CssStyle = fab("jsfiddle")
      def kaggle: CssStyle = fab("kaggle")
      def keybase: CssStyle = fab("keybase")
      def keycdn: CssStyle = fab("keycdn")
      def kickstarter: CssStyle = fab("kickstarter")
      def kickstarterK: CssStyle = fab("kickstarter-k")
      def korvue: CssStyle = fab("korvue")
      def laravel: CssStyle = fab("laravel")
      def lastfm: CssStyle = fab("lastfm")
      def lastfmSquare: CssStyle = fab("lastfm-square")
      def leanpub: CssStyle = fab("leanpub")
      def less: CssStyle = fab("less")
      def line: CssStyle = fab("line")
      def linkedin: CssStyle = fab("linkedin")
      def linkedinIn: CssStyle = fab("linkedin-in")
      def linode: CssStyle = fab("linode")
      def linux: CssStyle = fab("linux")
      def lyft: CssStyle = fab("lyft")
      def magento: CssStyle = fab("magento")
      def mailchimp: CssStyle = fab("mailchimp")
      def mandalorian: CssStyle = fab("mandalorian")
      def markdown: CssStyle = fab("markdown")
      def mastodon: CssStyle = fab("mastodon")
      def maxcdn: CssStyle = fab("maxcdn")
      def medapps: CssStyle = fab("medapps")
      def medium: CssStyle = fab("medium")
      def mediumM: CssStyle = fab("medium-m")
      def medrt: CssStyle = fab("medrt")
      def meetup: CssStyle = fab("meetup")
      def megaport: CssStyle = fab("megaport")
      def mendeley: CssStyle = fab("mendeley")
      def microsoft: CssStyle = fab("microsoft")
      def mix: CssStyle = fab("mix")
      def mixcloud: CssStyle = fab("mixcloud")
      def mizuni: CssStyle = fab("mizuni")
      def modx: CssStyle = fab("modx")
      def monero: CssStyle = fab("monero")
      def napster: CssStyle = fab("napster")
      def neos: CssStyle = fab("neos")
      def nimblr: CssStyle = fab("nimblr")
      def node: CssStyle = fab("node")
      def nodeJs: CssStyle = fab("node-js")
      def npm: CssStyle = fab("npm")
      def ns8: CssStyle = fab("ns8")
      def nutritionix: CssStyle = fab("nutritionix")
      def odnoklassniki: CssStyle = fab("odnoklassniki")
      def odnoklassnikiSquare: CssStyle = fab("odnoklassniki-square")
      def oldRepublic: CssStyle = fab("old-republic")
      def opencart: CssStyle = fab("opencart")
      def openid: CssStyle = fab("openid")
      def opera: CssStyle = fab("opera")
      def optinMonster: CssStyle = fab("optin-monster")
      def osi: CssStyle = fab("osi")
      def page4: CssStyle = fab("page4")
      def pagelines: CssStyle = fab("pagelines")
      def palfed: CssStyle = fab("palfed")
      def patreon: CssStyle = fab("patreon")
      def paypal: CssStyle = fab("paypal")
      def pennyArcade: CssStyle = fab("penny-arcade")
      def periscope: CssStyle = fab("periscope")
      def phabricator: CssStyle = fab("phabricator")
      def phoenixFramework: CssStyle = fab("phoenix-framework")
      def phoenixSquadron: CssStyle = fab("phoenix-squadron")
      def php: CssStyle = fab("php")
      def piedPiper: CssStyle = fab("pied-piper")
      def piedPiperAlt: CssStyle = fab("pied-piper-alt")
      def piedPiperHat: CssStyle = fab("pied-piper-hat")
      def piedPiperPp: CssStyle = fab("pied-piper-pp")
      def pinterest: CssStyle = fab("pinterest")
      def pinterestP: CssStyle = fab("pinterest-p")
      def pinterestSquare: CssStyle = fab("pinterest-square")
      def playstation: CssStyle = fab("playstation")
      def productHunt: CssStyle = fab("product-hunt")
      def pushed: CssStyle = fab("pushed")
      def python: CssStyle = fab("python")
      def qq: CssStyle = fab("qq")
      def quinscape: CssStyle = fab("quinscape")
      def quora: CssStyle = fab("quora")
      def rProject: CssStyle = fab("r-project")
      def raspberryPi: CssStyle = fab("raspberry-pi")
      def ravelry: CssStyle = fab("ravelry")
      def react: CssStyle = fab("react")
      def reacteurope: CssStyle = fab("reacteurope")
      def readme: CssStyle = fab("readme")
      def rebel: CssStyle = fab("rebel")
      def redRiver: CssStyle = fab("red-river")
      def reddit: CssStyle = fab("reddit")
      def redditAlien: CssStyle = fab("reddit-alien")
      def redditSquare: CssStyle = fab("reddit-square")
      def redhat: CssStyle = fab("redhat")
      def renren: CssStyle = fab("renren")
      def replyd: CssStyle = fab("replyd")
      def researchgate: CssStyle = fab("researchgate")
      def resolving: CssStyle = fab("resolving")
      def rev: CssStyle = fab("rev")
      def rocketchat: CssStyle = fab("rocketchat")
      def rockrms: CssStyle = fab("rockrms")
      def safari: CssStyle = fab("safari")
      def salesforce: CssStyle = fab("salesforce")
      def sass: CssStyle = fab("sass")
      def schlix: CssStyle = fab("schlix")
      def scribd: CssStyle = fab("scribd")
      def searchengin: CssStyle = fab("searchengin")
      def sellcast: CssStyle = fab("sellcast")
      def sellsy: CssStyle = fab("sellsy")
      def servicestack: CssStyle = fab("servicestack")
      def shirtsinbulk: CssStyle = fab("shirtsinbulk")
      def shopware: CssStyle = fab("shopware")
      def simplybuilt: CssStyle = fab("simplybuilt")
      def sistrix: CssStyle = fab("sistrix")
      def sith: CssStyle = fab("sith")
      def sketch: CssStyle = fab("sketch")
      def skyatlas: CssStyle = fab("skyatlas")
      def skype: CssStyle = fab("skype")
      def slack: CssStyle = fab("slack")
      def slackHash: CssStyle = fab("slack-hash")
      def slideshare: CssStyle = fab("slideshare")
      def snapchat: CssStyle = fab("snapchat")
      def snapchatGhost: CssStyle = fab("snapchat-ghost")
      def snapchatSquare: CssStyle = fab("snapchat-square")
      def soundcloud: CssStyle = fab("soundcloud")
      def sourcetree: CssStyle = fab("sourcetree")
      def speakap: CssStyle = fab("speakap")
      def speakerDeck: CssStyle = fab("speaker-deck")
      def spotify: CssStyle = fab("spotify")
      def squarespace: CssStyle = fab("squarespace")
      def stackExchange: CssStyle = fab("stack-exchange")
      def stackOverflow: CssStyle = fab("stack-overflow")
      def stackpath: CssStyle = fab("stackpath")
      def staylinked: CssStyle = fab("staylinked")
      def steam: CssStyle = fab("steam")
      def steamSquare: CssStyle = fab("steam-square")
      def steamSymbol: CssStyle = fab("steam-symbol")
      def stickerMule: CssStyle = fab("sticker-mule")
      def strava: CssStyle = fab("strava")
      def stripe: CssStyle = fab("stripe")
      def stripeS: CssStyle = fab("stripe-s")
      def studiovinari: CssStyle = fab("studiovinari")
      def stumbleupon: CssStyle = fab("stumbleupon")
      def stumbleuponCircle: CssStyle = fab("stumbleupon-circle")
      def superpowers: CssStyle = fab("superpowers")
      def supple: CssStyle = fab("supple")
      def suse: CssStyle = fab("suse")
      def symfony: CssStyle = fab("symfony")
      def teamspeak: CssStyle = fab("teamspeak")
      def telegram: CssStyle = fab("telegram")
      def telegramPlane: CssStyle = fab("telegram-plane")
      def tencentWeibo: CssStyle = fab("tencent-weibo")
      def theRedYeti: CssStyle = fab("the-red-yeti")
      def themeco: CssStyle = fab("themeco")
      def themeisle: CssStyle = fab("themeisle")
      def thinkPeaks: CssStyle = fab("think-peaks")
      def tradeFederation: CssStyle = fab("trade-federation")
      def trello: CssStyle = fab("trello")
      def tripadvisor: CssStyle = fab("tripadvisor")
      def tumblr: CssStyle = fab("tumblr")
      def tumblrSquare: CssStyle = fab("tumblr-square")
      def twitch: CssStyle = fab("twitch")
      def twitter: CssStyle = fab("twitter")
      def twitterSquare: CssStyle = fab("twitter-square")
      def typo3: CssStyle = fab("typo3")
      def uber: CssStyle = fab("uber")
      def ubuntu: CssStyle = fab("ubuntu")
      def uikit: CssStyle = fab("uikit")
      def uniregistry: CssStyle = fab("uniregistry")
      def untappd: CssStyle = fab("untappd")
      def ups: CssStyle = fab("ups")
      def usb: CssStyle = fab("usb")
      def usps: CssStyle = fab("usps")
      def ussunnah: CssStyle = fab("ussunnah")
      def vaadin: CssStyle = fab("vaadin")
      def viacoin: CssStyle = fab("viacoin")
      def viadeo: CssStyle = fab("viadeo")
      def viadeoSquare: CssStyle = fab("viadeo-square")
      def viber: CssStyle = fab("viber")
      def vimeo: CssStyle = fab("vimeo")
      def vimeoSquare: CssStyle = fab("vimeo-square")
      def vimeoV: CssStyle = fab("vimeo-v")
      def vine: CssStyle = fab("vine")
      def vk: CssStyle = fab("vk")
      def vnv: CssStyle = fab("vnv")
      def vuejs: CssStyle = fab("vuejs")
      def waze: CssStyle = fab("waze")
      def weebly: CssStyle = fab("weebly")
      def weibo: CssStyle = fab("weibo")
      def weixin: CssStyle = fab("weixin")
      def whatsapp: CssStyle = fab("whatsapp")
      def whatsappSquare: CssStyle = fab("whatsapp-square")
      def whmcs: CssStyle = fab("whmcs")
      def wikipediaW: CssStyle = fab("wikipedia-w")
      def windows: CssStyle = fab("windows")
      def wix: CssStyle = fab("wix")
      def wizardsOfTheCoast: CssStyle = fab("wizards-of-the-coast")
      def wolfPackBattalion: CssStyle = fab("wolf-pack-battalion")
      def wordpress: CssStyle = fab("wordpress")
      def wordpressSimple: CssStyle = fab("wordpress-simple")
      def wpbeginner: CssStyle = fab("wpbeginner")
      def wpexplorer: CssStyle = fab("wpexplorer")
      def wpforms: CssStyle = fab("wpforms")
      def wpressr: CssStyle = fab("wpressr")
      def xbox: CssStyle = fab("xbox")
      def xing: CssStyle = fab("xing")
      def xingSquare: CssStyle = fab("xing-square")
      def yCombinator: CssStyle = fab("y-combinator")
      def yahoo: CssStyle = fab("yahoo")
      def yammer: CssStyle = fab("yammer")
      def yandex: CssStyle = fab("yandex")
      def yandexInternational: CssStyle = fab("yandex-international")
      def yarn: CssStyle = fab("yarn")
      def yelp: CssStyle = fab("yelp")
      def yoast: CssStyle = fab("yoast")
      def youtube: CssStyle = fab("youtube")
      def youtubeSquare: CssStyle = fab("youtube-square")
      def zhihu: CssStyle = fab("zhihu")
    }

    object Regular {
      def addressBook: CssStyle = far("address-book")
      def addressCard: CssStyle = far("address-card")
      def angry: CssStyle = far("angry")
      def arrowAltCircleDown: CssStyle = far("arrow-alt-circle-down")
      def arrowAltCircleLeft: CssStyle = far("arrow-alt-circle-left")
      def arrowAltCircleRight: CssStyle = far("arrow-alt-circle-right")
      def arrowAltCircleUp: CssStyle = far("arrow-alt-circle-up")
      def bell: CssStyle = far("bell")
      def bellSlash: CssStyle = far("bell-slash")
      def bookmark: CssStyle = far("bookmark")
      def building: CssStyle = far("building")
      def calendar: CssStyle = far("calendar")
      def calendarAlt: CssStyle = far("calendar-alt")
      def calendarCheck: CssStyle = far("calendar-check")
      def calendarMinus: CssStyle = far("calendar-minus")
      def calendarPlus: CssStyle = far("calendar-plus")
      def calendarTimes: CssStyle = far("calendar-times")
      def caretSquareDown: CssStyle = far("caret-square-down")
      def caretSquareLeft: CssStyle = far("caret-square-left")
      def caretSquareRight: CssStyle = far("caret-square-right")
      def caretSquareUp: CssStyle = far("caret-square-up")
      def chartBar: CssStyle = far("chart-bar")
      def checkCircle: CssStyle = far("check-circle")
      def checkSquare: CssStyle = far("check-square")
      def circle: CssStyle = far("circle")
      def clipboard: CssStyle = far("clipboard")
      def clock: CssStyle = far("clock")
      def cloneIcon: CssStyle = far("clone")
      def closedCaptioning: CssStyle = far("closed-captioning")
      def comment: CssStyle = far("comment")
      def commentAlt: CssStyle = far("comment-alt")
      def commentDots: CssStyle = far("comment-dots")
      def comments: CssStyle = far("comments")
      def compass: CssStyle = far("compass")
      def copy: CssStyle = far("copy")
      def copyright: CssStyle = far("copyright")
      def creditCard: CssStyle = far("credit-card")
      def dizzy: CssStyle = far("dizzy")
      def dotCircle: CssStyle = far("dot-circle")
      def edit: CssStyle = far("edit")
      def envelope: CssStyle = far("envelope")
      def envelopeOpen: CssStyle = far("envelope-open")
      def eye: CssStyle = far("eye")
      def eyeSlash: CssStyle = far("eye-slash")
      def file: CssStyle = far("file")
      def fileAlt: CssStyle = far("file-alt")
      def fileArchive: CssStyle = far("file-archive")
      def fileAudio: CssStyle = far("file-audio")
      def fileCode: CssStyle = far("file-code")
      def fileExcel: CssStyle = far("file-excel")
      def fileImage: CssStyle = far("file-image")
      def filePdf: CssStyle = far("file-pdf")
      def filePowerpoint: CssStyle = far("file-powerpoint")
      def fileVideo: CssStyle = far("file-video")
      def fileWord: CssStyle = far("file-word")
      def flag: CssStyle = far("flag")
      def flushed: CssStyle = far("flushed")
      def folder: CssStyle = far("folder")
      def folderOpen: CssStyle = far("folder-open")
      def frown: CssStyle = far("frown")
      def frownOpen: CssStyle = far("frown-open")
      def futbol: CssStyle = far("futbol")
      def gem: CssStyle = far("gem")
      def grimace: CssStyle = far("grimace")
      def grin: CssStyle = far("grin")
      def grinAlt: CssStyle = far("grin-alt")
      def grinBeam: CssStyle = far("grin-beam")
      def grinBeamSweat: CssStyle = far("grin-beam-sweat")
      def grinHearts: CssStyle = far("grin-hearts")
      def grinSquint: CssStyle = far("grin-squint")
      def grinSquintTears: CssStyle = far("grin-squint-tears")
      def grinStars: CssStyle = far("grin-stars")
      def grinTears: CssStyle = far("grin-tears")
      def grinTongue: CssStyle = far("grin-tongue")
      def grinTongueSquint: CssStyle = far("grin-tongue-squint")
      def grinTongueWink: CssStyle = far("grin-tongue-wink")
      def grinWink: CssStyle = far("grin-wink")
      def handLizard: CssStyle = far("hand-lizard")
      def handPaper: CssStyle = far("hand-paper")
      def handPeace: CssStyle = far("hand-peace")
      def handPointDown: CssStyle = far("hand-point-down")
      def handPointLeft: CssStyle = far("hand-point-left")
      def handPointRight: CssStyle = far("hand-point-right")
      def handPointUp: CssStyle = far("hand-point-up")
      def handPointer: CssStyle = far("hand-pointer")
      def handRock: CssStyle = far("hand-rock")
      def handScissors: CssStyle = far("hand-scissors")
      def handSpock: CssStyle = far("hand-spock")
      def handshake: CssStyle = far("handshake")
      def hdd: CssStyle = far("hdd")
      def heart: CssStyle = far("heart")
      def hospital: CssStyle = far("hospital")
      def hourglass: CssStyle = far("hourglass")
      def idBadge: CssStyle = far("id-badge")
      def idCard: CssStyle = far("id-card")
      def image: CssStyle = far("image")
      def images: CssStyle = far("images")
      def keyboard: CssStyle = far("keyboard")
      def kiss: CssStyle = far("kiss")
      def kissBeam: CssStyle = far("kiss-beam")
      def kissWinkHeart: CssStyle = far("kiss-wink-heart")
      def laugh: CssStyle = far("laugh")
      def laughBeam: CssStyle = far("laugh-beam")
      def laughSquint: CssStyle = far("laugh-squint")
      def laughWink: CssStyle = far("laugh-wink")
      def lemon: CssStyle = far("lemon")
      def lifeRing: CssStyle = far("life-ring")
      def lightbulb: CssStyle = far("lightbulb")
      def listAlt: CssStyle = far("list-alt")
      def map: CssStyle = far("map")
      def meh: CssStyle = far("meh")
      def mehBlank: CssStyle = far("meh-blank")
      def mehRollingEyes: CssStyle = far("meh-rolling-eyes")
      def minusSquare: CssStyle = far("minus-square")
      def moneyBillAlt: CssStyle = far("money-bill-alt")
      def moon: CssStyle = far("moon")
      def newspaper: CssStyle = far("newspaper")
      def objectGroup: CssStyle = far("object-group")
      def objectUngroup: CssStyle = far("object-ungroup")
      def paperPlane: CssStyle = far("paper-plane")
      def pauseCircle: CssStyle = far("pause-circle")
      def playCircle: CssStyle = far("play-circle")
      def plusSquare: CssStyle = far("plus-square")
      def questionCircle: CssStyle = far("question-circle")
      def registered: CssStyle = far("registered")
      def sadCry: CssStyle = far("sad-cry")
      def sadTear: CssStyle = far("sad-tear")
      def save: CssStyle = far("save")
      def shareSquare: CssStyle = far("share-square")
      def smile: CssStyle = far("smile")
      def smileBeam: CssStyle = far("smile-beam")
      def smileWink: CssStyle = far("smile-wink")
      def snowflake: CssStyle = far("snowflake")
      def square: CssStyle = far("square")
      def star: CssStyle = far("star")
      def starHalf: CssStyle = far("star-half")
      def stickyNote: CssStyle = far("sticky-note")
      def stopCircle: CssStyle = far("stop-circle")
      def sun: CssStyle = far("sun")
      def surprise: CssStyle = far("surprise")
      def thumbsDown: CssStyle = far("thumbs-down")
      def thumbsUp: CssStyle = far("thumbs-up")
      def timesCircle: CssStyle = far("times-circle")
      def tired: CssStyle = far("tired")
      def trashAlt: CssStyle = far("trash-alt")
      def user: CssStyle = far("user")
      def userCircle: CssStyle = far("user-circle")
      def windowClose: CssStyle = far("window-close")
      def windowMaximize: CssStyle = far("window-maximize")
      def windowMinimize: CssStyle = far("window-minimize")
      def windowRestore: CssStyle = far("window-restore")
    }

    object Solid {
      def ad: CssStyle = fas("ad")
      def addressBook: CssStyle = fas("address-book")
      def addressCard: CssStyle = fas("address-card")
      def adjust: CssStyle = fas("adjust")
      def airFreshener: CssStyle = fas("air-freshener")
      def alignCenter: CssStyle = fas("align-center")
      def alignJustify: CssStyle = fas("align-justify")
      def alignLeft: CssStyle = fas("align-left")
      def alignRight: CssStyle = fas("align-right")
      def allergies: CssStyle = fas("allergies")
      def ambulance: CssStyle = fas("ambulance")
      def americanSignLanguageInterpreting: CssStyle = fas("american-sign-language-interpreting")
      def anchor: CssStyle = fas("anchor")
      def angleDoubleDown: CssStyle = fas("angle-double-down")
      def angleDoubleLeft: CssStyle = fas("angle-double-left")
      def angleDoubleRight: CssStyle = fas("angle-double-right")
      def angleDoubleUp: CssStyle = fas("angle-double-up")
      def angleDown: CssStyle = fas("angle-down")
      def angleLeft: CssStyle = fas("angle-left")
      def angleRight: CssStyle = fas("angle-right")
      def angleUp: CssStyle = fas("angle-up")
      def angry: CssStyle = fas("angry")
      def ankh: CssStyle = fas("ankh")
      def appleAlt: CssStyle = fas("apple-alt")
      def archive: CssStyle = fas("archive")
      def archway: CssStyle = fas("archway")
      def arrowAltCircleDown: CssStyle = fas("arrow-alt-circle-down")
      def arrowAltCircleLeft: CssStyle = fas("arrow-alt-circle-left")
      def arrowAltCircleRight: CssStyle = fas("arrow-alt-circle-right")
      def arrowAltCircleUp: CssStyle = fas("arrow-alt-circle-up")
      def arrowCircleDown: CssStyle = fas("arrow-circle-down")
      def arrowCircleLeft: CssStyle = fas("arrow-circle-left")
      def arrowCircleRight: CssStyle = fas("arrow-circle-right")
      def arrowCircleUp: CssStyle = fas("arrow-circle-up")
      def arrowDown: CssStyle = fas("arrow-down")
      def arrowLeft: CssStyle = fas("arrow-left")
      def arrowRight: CssStyle = fas("arrow-right")
      def arrowUp: CssStyle = fas("arrow-up")
      def arrowsAlt: CssStyle = fas("arrows-alt")
      def arrowsAltH: CssStyle = fas("arrows-alt-h")
      def arrowsAltV: CssStyle = fas("arrows-alt-v")
      def assistiveListeningSystems: CssStyle = fas("assistive-listening-systems")
      def asterisk: CssStyle = fas("asterisk")
      def at: CssStyle = fas("at")
      def atlas: CssStyle = fas("atlas")
      def atom: CssStyle = fas("atom")
      def audioDescription: CssStyle = fas("audio-description")
      def award: CssStyle = fas("award")
      def baby: CssStyle = fas("baby")
      def babyCarriage: CssStyle = fas("baby-carriage")
      def backspace: CssStyle = fas("backspace")
      def backward: CssStyle = fas("backward")
      def bacon: CssStyle = fas("bacon")
      def balanceScale: CssStyle = fas("balance-scale")
      def balanceScaleLeft: CssStyle = fas("balance-scale-left")
      def balanceScaleRight: CssStyle = fas("balance-scale-right")
      def ban: CssStyle = fas("ban")
      def bandAid: CssStyle = fas("band-aid")
      def barcode: CssStyle = fas("barcode")
      def bars: CssStyle = fas("bars")
      def baseballBall: CssStyle = fas("baseball-ball")
      def basketballBall: CssStyle = fas("basketball-ball")
      def bath: CssStyle = fas("bath")
      def batteryEmpty: CssStyle = fas("battery-empty")
      def batteryFull: CssStyle = fas("battery-full")
      def batteryHalf: CssStyle = fas("battery-half")
      def batteryQuarter: CssStyle = fas("battery-quarter")
      def batteryThreeQuarters: CssStyle = fas("battery-three-quarters")
      def bed: CssStyle = fas("bed")
      def beer: CssStyle = fas("beer")
      def bell: CssStyle = fas("bell")
      def bellSlash: CssStyle = fas("bell-slash")
      def bezierCurve: CssStyle = fas("bezier-curve")
      def bible: CssStyle = fas("bible")
      def bicycle: CssStyle = fas("bicycle")
      def biking: CssStyle = fas("biking")
      def binoculars: CssStyle = fas("binoculars")
      def biohazard: CssStyle = fas("biohazard")
      def birthdayCake: CssStyle = fas("birthday-cake")
      def blender: CssStyle = fas("blender")
      def blenderPhone: CssStyle = fas("blender-phone")
      def blind: CssStyle = fas("blind")
      def blog: CssStyle = fas("blog")
      def bold: CssStyle = fas("bold")
      def bolt: CssStyle = fas("bolt")
      def bomb: CssStyle = fas("bomb")
      def bone: CssStyle = fas("bone")
      def bong: CssStyle = fas("bong")
      def book: CssStyle = fas("book")
      def bookDead: CssStyle = fas("book-dead")
      def bookMedical: CssStyle = fas("book-medical")
      def bookOpen: CssStyle = fas("book-open")
      def bookReader: CssStyle = fas("book-reader")
      def bookmark: CssStyle = fas("bookmark")
      def borderAll: CssStyle = fas("border-all")
      def borderNone: CssStyle = fas("border-none")
      def borderStyle: CssStyle = fas("border-style")
      def bowlingBall: CssStyle = fas("bowling-ball")
      def box: CssStyle = fas("box")
      def boxOpen: CssStyle = fas("box-open")
      def boxes: CssStyle = fas("boxes")
      def braille: CssStyle = fas("braille")
      def brain: CssStyle = fas("brain")
      def breadSlice: CssStyle = fas("bread-slice")
      def briefcase: CssStyle = fas("briefcase")
      def briefcaseMedical: CssStyle = fas("briefcase-medical")
      def broadcastTower: CssStyle = fas("broadcast-tower")
      def broom: CssStyle = fas("broom")
      def brush: CssStyle = fas("brush")
      def bug: CssStyle = fas("bug")
      def building: CssStyle = fas("building")
      def bullhorn: CssStyle = fas("bullhorn")
      def bullseye: CssStyle = fas("bullseye")
      def burn: CssStyle = fas("burn")
      def bus: CssStyle = fas("bus")
      def busAlt: CssStyle = fas("bus-alt")
      def businessTime: CssStyle = fas("business-time")
      def calculator: CssStyle = fas("calculator")
      def calendar: CssStyle = fas("calendar")
      def calendarAlt: CssStyle = fas("calendar-alt")
      def calendarCheck: CssStyle = fas("calendar-check")
      def calendarDay: CssStyle = fas("calendar-day")
      def calendarMinus: CssStyle = fas("calendar-minus")
      def calendarPlus: CssStyle = fas("calendar-plus")
      def calendarTimes: CssStyle = fas("calendar-times")
      def calendarWeek: CssStyle = fas("calendar-week")
      def camera: CssStyle = fas("camera")
      def cameraRetro: CssStyle = fas("camera-retro")
      def campground: CssStyle = fas("campground")
      def candyCane: CssStyle = fas("candy-cane")
      def cannabis: CssStyle = fas("cannabis")
      def capsules: CssStyle = fas("capsules")
      def car: CssStyle = fas("car")
      def carAlt: CssStyle = fas("car-alt")
      def carBattery: CssStyle = fas("car-battery")
      def carCrash: CssStyle = fas("car-crash")
      def carSide: CssStyle = fas("car-side")
      def caretDown: CssStyle = fas("caret-down")
      def caretLeft: CssStyle = fas("caret-left")
      def caretRight: CssStyle = fas("caret-right")
      def caretSquareDown: CssStyle = fas("caret-square-down")
      def caretSquareLeft: CssStyle = fas("caret-square-left")
      def caretSquareRight: CssStyle = fas("caret-square-right")
      def caretSquareUp: CssStyle = fas("caret-square-up")
      def caretUp: CssStyle = fas("caret-up")
      def carrot: CssStyle = fas("carrot")
      def cartArrowDown: CssStyle = fas("cart-arrow-down")
      def cartPlus: CssStyle = fas("cart-plus")
      def cashRegister: CssStyle = fas("cash-register")
      def cat: CssStyle = fas("cat")
      def certificate: CssStyle = fas("certificate")
      def chair: CssStyle = fas("chair")
      def chalkboard: CssStyle = fas("chalkboard")
      def chalkboardTeacher: CssStyle = fas("chalkboard-teacher")
      def chargingStation: CssStyle = fas("charging-station")
      def chartArea: CssStyle = fas("chart-area")
      def chartBar: CssStyle = fas("chart-bar")
      def chartLine: CssStyle = fas("chart-line")
      def chartPie: CssStyle = fas("chart-pie")
      def check: CssStyle = fas("check")
      def checkCircle: CssStyle = fas("check-circle")
      def checkDouble: CssStyle = fas("check-double")
      def checkSquare: CssStyle = fas("check-square")
      def cheese: CssStyle = fas("cheese")
      def chess: CssStyle = fas("chess")
      def chessBishop: CssStyle = fas("chess-bishop")
      def chessBoard: CssStyle = fas("chess-board")
      def chessKing: CssStyle = fas("chess-king")
      def chessKnight: CssStyle = fas("chess-knight")
      def chessPawn: CssStyle = fas("chess-pawn")
      def chessQueen: CssStyle = fas("chess-queen")
      def chessRook: CssStyle = fas("chess-rook")
      def chevronCircleDown: CssStyle = fas("chevron-circle-down")
      def chevronCircleLeft: CssStyle = fas("chevron-circle-left")
      def chevronCircleRight: CssStyle = fas("chevron-circle-right")
      def chevronCircleUp: CssStyle = fas("chevron-circle-up")
      def chevronDown: CssStyle = fas("chevron-down")
      def chevronLeft: CssStyle = fas("chevron-left")
      def chevronRight: CssStyle = fas("chevron-right")
      def chevronUp: CssStyle = fas("chevron-up")
      def child: CssStyle = fas("child")
      def church: CssStyle = fas("church")
      def circle: CssStyle = fas("circle")
      def circleNotch: CssStyle = fas("circle-notch")
      def city: CssStyle = fas("city")
      def clinicMedical: CssStyle = fas("clinic-medical")
      def clipboard: CssStyle = fas("clipboard")
      def clipboardCheck: CssStyle = fas("clipboard-check")
      def clipboardList: CssStyle = fas("clipboard-list")
      def clock: CssStyle = fas("clock")
      def cloneIcon: CssStyle = fas("clone")
      def closedCaptioning: CssStyle = fas("closed-captioning")
      def cloud: CssStyle = fas("cloud")
      def cloudDownloadAlt: CssStyle = fas("cloud-download-alt")
      def cloudMeatball: CssStyle = fas("cloud-meatball")
      def cloudMoon: CssStyle = fas("cloud-moon")
      def cloudMoonRain: CssStyle = fas("cloud-moon-rain")
      def cloudRain: CssStyle = fas("cloud-rain")
      def cloudShowersHeavy: CssStyle = fas("cloud-showers-heavy")
      def cloudSun: CssStyle = fas("cloud-sun")
      def cloudSunRain: CssStyle = fas("cloud-sun-rain")
      def cloudUploadAlt: CssStyle = fas("cloud-upload-alt")
      def cocktail: CssStyle = fas("cocktail")
      def code: CssStyle = fas("code")
      def codeBranch: CssStyle = fas("code-branch")
      def coffee: CssStyle = fas("coffee")
      def cog: CssStyle = fas("cog")
      def cogs: CssStyle = fas("cogs")
      def coins: CssStyle = fas("coins")
      def columns: CssStyle = fas("columns")
      def comment: CssStyle = fas("comment")
      def commentAlt: CssStyle = fas("comment-alt")
      def commentDollar: CssStyle = fas("comment-dollar")
      def commentDots: CssStyle = fas("comment-dots")
      def commentMedical: CssStyle = fas("comment-medical")
      def commentSlash: CssStyle = fas("comment-slash")
      def comments: CssStyle = fas("comments")
      def commentsDollar: CssStyle = fas("comments-dollar")
      def compactDisc: CssStyle = fas("compact-disc")
      def compass: CssStyle = fas("compass")
      def compress: CssStyle = fas("compress")
      def compressArrowsAlt: CssStyle = fas("compress-arrows-alt")
      def conciergeBell: CssStyle = fas("concierge-bell")
      def cookie: CssStyle = fas("cookie")
      def cookieBite: CssStyle = fas("cookie-bite")
      def copy: CssStyle = fas("copy")
      def copyright: CssStyle = fas("copyright")
      def couch: CssStyle = fas("couch")
      def creditCard: CssStyle = fas("credit-card")
      def crop: CssStyle = fas("crop")
      def cropAlt: CssStyle = fas("crop-alt")
      def cross: CssStyle = fas("cross")
      def crosshairs: CssStyle = fas("crosshairs")
      def crow: CssStyle = fas("crow")
      def crown: CssStyle = fas("crown")
      def crutch: CssStyle = fas("crutch")
      def cube: CssStyle = fas("cube")
      def cubes: CssStyle = fas("cubes")
      def cut: CssStyle = fas("cut")
      def database: CssStyle = fas("database")
      def deaf: CssStyle = fas("deaf")
      def democrat: CssStyle = fas("democrat")
      def desktop: CssStyle = fas("desktop")
      def dharmachakra: CssStyle = fas("dharmachakra")
      def diagnoses: CssStyle = fas("diagnoses")
      def dice: CssStyle = fas("dice")
      def diceD20: CssStyle = fas("dice-d20")
      def diceD6: CssStyle = fas("dice-d6")
      def diceFive: CssStyle = fas("dice-five")
      def diceFour: CssStyle = fas("dice-four")
      def diceOne: CssStyle = fas("dice-one")
      def diceSix: CssStyle = fas("dice-six")
      def diceThree: CssStyle = fas("dice-three")
      def diceTwo: CssStyle = fas("dice-two")
      def digitalTachograph: CssStyle = fas("digital-tachograph")
      def directions: CssStyle = fas("directions")
      def divide: CssStyle = fas("divide")
      def dizzy: CssStyle = fas("dizzy")
      def dna: CssStyle = fas("dna")
      def dog: CssStyle = fas("dog")
      def dollarSign: CssStyle = fas("dollar-sign")
      def dolly: CssStyle = fas("dolly")
      def dollyFlatbed: CssStyle = fas("dolly-flatbed")
      def donate: CssStyle = fas("donate")
      def doorClosed: CssStyle = fas("door-closed")
      def doorOpen: CssStyle = fas("door-open")
      def dotCircle: CssStyle = fas("dot-circle")
      def dove: CssStyle = fas("dove")
      def download: CssStyle = fas("download")
      def draftingCompass: CssStyle = fas("drafting-compass")
      def dragon: CssStyle = fas("dragon")
      def drawPolygon: CssStyle = fas("draw-polygon")
      def drum: CssStyle = fas("drum")
      def drumSteelpan: CssStyle = fas("drum-steelpan")
      def drumstickBite: CssStyle = fas("drumstick-bite")
      def dumbbell: CssStyle = fas("dumbbell")
      def dumpster: CssStyle = fas("dumpster")
      def dumpsterFire: CssStyle = fas("dumpster-fire")
      def dungeon: CssStyle = fas("dungeon")
      def edit: CssStyle = fas("edit")
      def egg: CssStyle = fas("egg")
      def eject: CssStyle = fas("eject")
      def ellipsisH: CssStyle = fas("ellipsis-h")
      def ellipsisV: CssStyle = fas("ellipsis-v")
      def envelope: CssStyle = fas("envelope")
      def envelopeOpen: CssStyle = fas("envelope-open")
      def envelopeOpenText: CssStyle = fas("envelope-open-text")
      def envelopeSquare: CssStyle = fas("envelope-square")
      def equals: CssStyle = fas("equals")
      def eraser: CssStyle = fas("eraser")
      def ethernet: CssStyle = fas("ethernet")
      def euroSign: CssStyle = fas("euro-sign")
      def exchangeAlt: CssStyle = fas("exchange-alt")
      def exclamation: CssStyle = fas("exclamation")
      def exclamationCircle: CssStyle = fas("exclamation-circle")
      def exclamationTriangle: CssStyle = fas("exclamation-triangle")
      def expand: CssStyle = fas("expand")
      def expandArrowsAlt: CssStyle = fas("expand-arrows-alt")
      def externalLinkAlt: CssStyle = fas("external-link-alt")
      def externalLinkSquareAlt: CssStyle = fas("external-link-square-alt")
      def eye: CssStyle = fas("eye")
      def eyeDropper: CssStyle = fas("eye-dropper")
      def eyeSlash: CssStyle = fas("eye-slash")
      def fan: CssStyle = fas("fan")
      def fastBackward: CssStyle = fas("fast-backward")
      def fastForward: CssStyle = fas("fast-forward")
      def fax: CssStyle = fas("fax")
      def feather: CssStyle = fas("feather")
      def featherAlt: CssStyle = fas("feather-alt")
      def female: CssStyle = fas("female")
      def fighterJet: CssStyle = fas("fighter-jet")
      def file: CssStyle = fas("file")
      def fileAlt: CssStyle = fas("file-alt")
      def fileArchive: CssStyle = fas("file-archive")
      def fileAudio: CssStyle = fas("file-audio")
      def fileCode: CssStyle = fas("file-code")
      def fileContract: CssStyle = fas("file-contract")
      def fileCsv: CssStyle = fas("file-csv")
      def fileDownload: CssStyle = fas("file-download")
      def fileExcel: CssStyle = fas("file-excel")
      def fileExport: CssStyle = fas("file-export")
      def fileImage: CssStyle = fas("file-image")
      def fileImport: CssStyle = fas("file-import")
      def fileInvoice: CssStyle = fas("file-invoice")
      def fileInvoiceDollar: CssStyle = fas("file-invoice-dollar")
      def fileMedical: CssStyle = fas("file-medical")
      def fileMedicalAlt: CssStyle = fas("file-medical-alt")
      def filePdf: CssStyle = fas("file-pdf")
      def filePowerpoint: CssStyle = fas("file-powerpoint")
      def filePrescription: CssStyle = fas("file-prescription")
      def fileSignature: CssStyle = fas("file-signature")
      def fileUpload: CssStyle = fas("file-upload")
      def fileVideo: CssStyle = fas("file-video")
      def fileWord: CssStyle = fas("file-word")
      def fill: CssStyle = fas("fill")
      def fillDrip: CssStyle = fas("fill-drip")
      def film: CssStyle = fas("film")
      def filter: CssStyle = fas("filter")
      def fingerprint: CssStyle = fas("fingerprint")
      def fire: CssStyle = fas("fire")
      def fireAlt: CssStyle = fas("fire-alt")
      def fireExtinguisher: CssStyle = fas("fire-extinguisher")
      def firstAid: CssStyle = fas("first-aid")
      def fish: CssStyle = fas("fish")
      def fistRaised: CssStyle = fas("fist-raised")
      def flag: CssStyle = fas("flag")
      def flagCheckered: CssStyle = fas("flag-checkered")
      def flagUsa: CssStyle = fas("flag-usa")
      def flask: CssStyle = fas("flask")
      def flushed: CssStyle = fas("flushed")
      def folder: CssStyle = fas("folder")
      def folderMinus: CssStyle = fas("folder-minus")
      def folderOpen: CssStyle = fas("folder-open")
      def folderPlus: CssStyle = fas("folder-plus")
      def font: CssStyle = fas("font")
      def footballBall: CssStyle = fas("football-ball")
      def forward: CssStyle = fas("forward")
      def frog: CssStyle = fas("frog")
      def frown: CssStyle = fas("frown")
      def frownOpen: CssStyle = fas("frown-open")
      def funnelDollar: CssStyle = fas("funnel-dollar")
      def futbol: CssStyle = fas("futbol")
      def gamepad: CssStyle = fas("gamepad")
      def gasPump: CssStyle = fas("gas-pump")
      def gavel: CssStyle = fas("gavel")
      def gem: CssStyle = fas("gem")
      def genderless: CssStyle = fas("genderless")
      def ghost: CssStyle = fas("ghost")
      def gift: CssStyle = fas("gift")
      def gifts: CssStyle = fas("gifts")
      def glassCheers: CssStyle = fas("glass-cheers")
      def glassMartini: CssStyle = fas("glass-martini")
      def glassMartiniAlt: CssStyle = fas("glass-martini-alt")
      def glassWhiskey: CssStyle = fas("glass-whiskey")
      def glasses: CssStyle = fas("glasses")
      def globe: CssStyle = fas("globe")
      def globeAfrica: CssStyle = fas("globe-africa")
      def globeAmericas: CssStyle = fas("globe-americas")
      def globeAsia: CssStyle = fas("globe-asia")
      def globeEurope: CssStyle = fas("globe-europe")
      def golfBall: CssStyle = fas("golf-ball")
      def gopuram: CssStyle = fas("gopuram")
      def graduationCap: CssStyle = fas("graduation-cap")
      def greaterThan: CssStyle = fas("greater-than")
      def greaterThanEqual: CssStyle = fas("greater-than-equal")
      def grimace: CssStyle = fas("grimace")
      def grin: CssStyle = fas("grin")
      def grinAlt: CssStyle = fas("grin-alt")
      def grinBeam: CssStyle = fas("grin-beam")
      def grinBeamSweat: CssStyle = fas("grin-beam-sweat")
      def grinHearts: CssStyle = fas("grin-hearts")
      def grinSquint: CssStyle = fas("grin-squint")
      def grinSquintTears: CssStyle = fas("grin-squint-tears")
      def grinStars: CssStyle = fas("grin-stars")
      def grinTears: CssStyle = fas("grin-tears")
      def grinTongue: CssStyle = fas("grin-tongue")
      def grinTongueSquint: CssStyle = fas("grin-tongue-squint")
      def grinTongueWink: CssStyle = fas("grin-tongue-wink")
      def grinWink: CssStyle = fas("grin-wink")
      def gripHorizontal: CssStyle = fas("grip-horizontal")
      def gripLines: CssStyle = fas("grip-lines")
      def gripLinesVertical: CssStyle = fas("grip-lines-vertical")
      def gripVertical: CssStyle = fas("grip-vertical")
      def guitar: CssStyle = fas("guitar")
      def hSquare: CssStyle = fas("h-square")
      def hamburger: CssStyle = fas("hamburger")
      def hammer: CssStyle = fas("hammer")
      def hamsa: CssStyle = fas("hamsa")
      def handHolding: CssStyle = fas("hand-holding")
      def handHoldingHeart: CssStyle = fas("hand-holding-heart")
      def handHoldingUsd: CssStyle = fas("hand-holding-usd")
      def handLizard: CssStyle = fas("hand-lizard")
      def handMiddleFinger: CssStyle = fas("hand-middle-finger")
      def handPaper: CssStyle = fas("hand-paper")
      def handPeace: CssStyle = fas("hand-peace")
      def handPointDown: CssStyle = fas("hand-point-down")
      def handPointLeft: CssStyle = fas("hand-point-left")
      def handPointRight: CssStyle = fas("hand-point-right")
      def handPointUp: CssStyle = fas("hand-point-up")
      def handPointer: CssStyle = fas("hand-pointer")
      def handRock: CssStyle = fas("hand-rock")
      def handScissors: CssStyle = fas("hand-scissors")
      def handSpock: CssStyle = fas("hand-spock")
      def hands: CssStyle = fas("hands")
      def handsHelping: CssStyle = fas("hands-helping")
      def handshake: CssStyle = fas("handshake")
      def hanukiah: CssStyle = fas("hanukiah")
      def hardHat: CssStyle = fas("hard-hat")
      def hashtag: CssStyle = fas("hashtag")
      def hatWizard: CssStyle = fas("hat-wizard")
      def haykal: CssStyle = fas("haykal")
      def hdd: CssStyle = fas("hdd")
      def heading: CssStyle = fas("heading")
      def headphones: CssStyle = fas("headphones")
      def headphonesAlt: CssStyle = fas("headphones-alt")
      def headset: CssStyle = fas("headset")
      def heart: CssStyle = fas("heart")
      def heartBroken: CssStyle = fas("heart-broken")
      def heartbeat: CssStyle = fas("heartbeat")
      def helicopter: CssStyle = fas("helicopter")
      def highlighter: CssStyle = fas("highlighter")
      def hiking: CssStyle = fas("hiking")
      def hippo: CssStyle = fas("hippo")
      def history: CssStyle = fas("history")
      def hockeyPuck: CssStyle = fas("hockey-puck")
      def hollyBerry: CssStyle = fas("holly-berry")
      def home: CssStyle = fas("home")
      def horse: CssStyle = fas("horse")
      def horseHead: CssStyle = fas("horse-head")
      def hospital: CssStyle = fas("hospital")
      def hospitalAlt: CssStyle = fas("hospital-alt")
      def hospitalSymbol: CssStyle = fas("hospital-symbol")
      def hotTub: CssStyle = fas("hot-tub")
      def hotdog: CssStyle = fas("hotdog")
      def hotel: CssStyle = fas("hotel")
      def hourglass: CssStyle = fas("hourglass")
      def hourglassEnd: CssStyle = fas("hourglass-end")
      def hourglassHalf: CssStyle = fas("hourglass-half")
      def hourglassStart: CssStyle = fas("hourglass-start")
      def houseDamage: CssStyle = fas("house-damage")
      def hryvnia: CssStyle = fas("hryvnia")
      def iCursor: CssStyle = fas("i-cursor")
      def iceCream: CssStyle = fas("ice-cream")
      def icicles: CssStyle = fas("icicles")
      def icons: CssStyle = fas("icons")
      def idBadge: CssStyle = fas("id-badge")
      def idCard: CssStyle = fas("id-card")
      def idCardAlt: CssStyle = fas("id-card-alt")
      def igloo: CssStyle = fas("igloo")
      def image: CssStyle = fas("image")
      def images: CssStyle = fas("images")
      def inbox: CssStyle = fas("inbox")
      def indent: CssStyle = fas("indent")
      def industry: CssStyle = fas("industry")
      def infinity: CssStyle = fas("infinity")
      def info: CssStyle = fas("info")
      def infoCircle: CssStyle = fas("info-circle")
      def italic: CssStyle = fas("italic")
      def jedi: CssStyle = fas("jedi")
      def joint: CssStyle = fas("joint")
      def journalWhills: CssStyle = fas("journal-whills")
      def kaaba: CssStyle = fas("kaaba")
      def key: CssStyle = fas("key")
      def keyboard: CssStyle = fas("keyboard")
      def khanda: CssStyle = fas("khanda")
      def kiss: CssStyle = fas("kiss")
      def kissBeam: CssStyle = fas("kiss-beam")
      def kissWinkHeart: CssStyle = fas("kiss-wink-heart")
      def kiwiBird: CssStyle = fas("kiwi-bird")
      def landmark: CssStyle = fas("landmark")
      def language: CssStyle = fas("language")
      def laptop: CssStyle = fas("laptop")
      def laptopCode: CssStyle = fas("laptop-code")
      def laptopMedical: CssStyle = fas("laptop-medical")
      def laugh: CssStyle = fas("laugh")
      def laughBeam: CssStyle = fas("laugh-beam")
      def laughSquint: CssStyle = fas("laugh-squint")
      def laughWink: CssStyle = fas("laugh-wink")
      def layerGroup: CssStyle = fas("layer-group")
      def leaf: CssStyle = fas("leaf")
      def lemon: CssStyle = fas("lemon")
      def lessThan: CssStyle = fas("less-than")
      def lessThanEqual: CssStyle = fas("less-than-equal")
      def levelDownAlt: CssStyle = fas("level-down-alt")
      def levelUpAlt: CssStyle = fas("level-up-alt")
      def lifeRing: CssStyle = fas("life-ring")
      def lightbulb: CssStyle = fas("lightbulb")
      def link: CssStyle = fas("link")
      def liraSign: CssStyle = fas("lira-sign")
      def list: CssStyle = fas("list")
      def listAlt: CssStyle = fas("list-alt")
      def listOl: CssStyle = fas("list-ol")
      def listUl: CssStyle = fas("list-ul")
      def locationArrow: CssStyle = fas("location-arrow")
      def lock: CssStyle = fas("lock")
      def lockOpen: CssStyle = fas("lock-open")
      def longArrowAltDown: CssStyle = fas("long-arrow-alt-down")
      def longArrowAltLeft: CssStyle = fas("long-arrow-alt-left")
      def longArrowAltRight: CssStyle = fas("long-arrow-alt-right")
      def longArrowAltUp: CssStyle = fas("long-arrow-alt-up")
      def lowVision: CssStyle = fas("low-vision")
      def luggageCart: CssStyle = fas("luggage-cart")
      def magic: CssStyle = fas("magic")
      def magnet: CssStyle = fas("magnet")
      def mailBulk: CssStyle = fas("mail-bulk")
      def male: CssStyle = fas("male")
      def map: CssStyle = fas("map")
      def mapMarked: CssStyle = fas("map-marked")
      def mapMarkedAlt: CssStyle = fas("map-marked-alt")
      def mapMarker: CssStyle = fas("map-marker")
      def mapMarkerAlt: CssStyle = fas("map-marker-alt")
      def mapPin: CssStyle = fas("map-pin")
      def mapSigns: CssStyle = fas("map-signs")
      def marker: CssStyle = fas("marker")
      def mars: CssStyle = fas("mars")
      def marsDouble: CssStyle = fas("mars-double")
      def marsStroke: CssStyle = fas("mars-stroke")
      def marsStrokeH: CssStyle = fas("mars-stroke-h")
      def marsStrokeV: CssStyle = fas("mars-stroke-v")
      def mask: CssStyle = fas("mask")
      def medal: CssStyle = fas("medal")
      def medkit: CssStyle = fas("medkit")
      def meh: CssStyle = fas("meh")
      def mehBlank: CssStyle = fas("meh-blank")
      def mehRollingEyes: CssStyle = fas("meh-rolling-eyes")
      def memory: CssStyle = fas("memory")
      def menorah: CssStyle = fas("menorah")
      def mercury: CssStyle = fas("mercury")
      def meteor: CssStyle = fas("meteor")
      def microchip: CssStyle = fas("microchip")
      def microphone: CssStyle = fas("microphone")
      def microphoneAlt: CssStyle = fas("microphone-alt")
      def microphoneAltSlash: CssStyle = fas("microphone-alt-slash")
      def microphoneSlash: CssStyle = fas("microphone-slash")
      def microscope: CssStyle = fas("microscope")
      def minus: CssStyle = fas("minus")
      def minusCircle: CssStyle = fas("minus-circle")
      def minusSquare: CssStyle = fas("minus-square")
      def mitten: CssStyle = fas("mitten")
      def mobile: CssStyle = fas("mobile")
      def mobileAlt: CssStyle = fas("mobile-alt")
      def moneyBill: CssStyle = fas("money-bill")
      def moneyBillAlt: CssStyle = fas("money-bill-alt")
      def moneyBillWave: CssStyle = fas("money-bill-wave")
      def moneyBillWaveAlt: CssStyle = fas("money-bill-wave-alt")
      def moneyCheck: CssStyle = fas("money-check")
      def moneyCheckAlt: CssStyle = fas("money-check-alt")
      def monument: CssStyle = fas("monument")
      def moon: CssStyle = fas("moon")
      def mortarPestle: CssStyle = fas("mortar-pestle")
      def mosque: CssStyle = fas("mosque")
      def motorcycle: CssStyle = fas("motorcycle")
      def mountain: CssStyle = fas("mountain")
      def mousePointer: CssStyle = fas("mouse-pointer")
      def mugHot: CssStyle = fas("mug-hot")
      def music: CssStyle = fas("music")
      def networkWired: CssStyle = fas("network-wired")
      def neuter: CssStyle = fas("neuter")
      def newspaper: CssStyle = fas("newspaper")
      def notEqual: CssStyle = fas("not-equal")
      def notesMedical: CssStyle = fas("notes-medical")
      def objectGroup: CssStyle = fas("object-group")
      def objectUngroup: CssStyle = fas("object-ungroup")
      def oilCan: CssStyle = fas("oil-can")
      def om: CssStyle = fas("om")
      def otter: CssStyle = fas("otter")
      def outdent: CssStyle = fas("outdent")
      def pager: CssStyle = fas("pager")
      def paintBrush: CssStyle = fas("paint-brush")
      def paintRoller: CssStyle = fas("paint-roller")
      def palette: CssStyle = fas("palette")
      def pallet: CssStyle = fas("pallet")
      def paperPlane: CssStyle = fas("paper-plane")
      def paperclip: CssStyle = fas("paperclip")
      def parachuteBox: CssStyle = fas("parachute-box")
      def paragraph: CssStyle = fas("paragraph")
      def parking: CssStyle = fas("parking")
      def passport: CssStyle = fas("passport")
      def pastafarianism: CssStyle = fas("pastafarianism")
      def paste: CssStyle = fas("paste")
      def pause: CssStyle = fas("pause")
      def pauseCircle: CssStyle = fas("pause-circle")
      def paw: CssStyle = fas("paw")
      def peace: CssStyle = fas("peace")
      def pen: CssStyle = fas("pen")
      def penAlt: CssStyle = fas("pen-alt")
      def penFancy: CssStyle = fas("pen-fancy")
      def penNib: CssStyle = fas("pen-nib")
      def penSquare: CssStyle = fas("pen-square")
      def pencilAlt: CssStyle = fas("pencil-alt")
      def pencilRuler: CssStyle = fas("pencil-ruler")
      def peopleCarry: CssStyle = fas("people-carry")
      def pepperHot: CssStyle = fas("pepper-hot")
      def percent: CssStyle = fas("percent")
      def percentage: CssStyle = fas("percentage")
      def personBooth: CssStyle = fas("person-booth")
      def phone: CssStyle = fas("phone")
      def phoneAlt: CssStyle = fas("phone-alt")
      def phoneSlash: CssStyle = fas("phone-slash")
      def phoneSquare: CssStyle = fas("phone-square")
      def phoneSquareAlt: CssStyle = fas("phone-square-alt")
      def phoneVolume: CssStyle = fas("phone-volume")
      def photoVideo: CssStyle = fas("photo-video")
      def piggyBank: CssStyle = fas("piggy-bank")
      def pills: CssStyle = fas("pills")
      def pizzaSlice: CssStyle = fas("pizza-slice")
      def placeOfWorship: CssStyle = fas("place-of-worship")
      def plane: CssStyle = fas("plane")
      def planeArrival: CssStyle = fas("plane-arrival")
      def planeDeparture: CssStyle = fas("plane-departure")
      def play: CssStyle = fas("play")
      def playCircle: CssStyle = fas("play-circle")
      def plug: CssStyle = fas("plug")
      def plus: CssStyle = fas("plus")
      def plusCircle: CssStyle = fas("plus-circle")
      def plusSquare: CssStyle = fas("plus-square")
      def podcast: CssStyle = fas("podcast")
      def poll: CssStyle = fas("poll")
      def pollH: CssStyle = fas("poll-h")
      def poo: CssStyle = fas("poo")
      def pooStorm: CssStyle = fas("poo-storm")
      def poop: CssStyle = fas("poop")
      def portrait: CssStyle = fas("portrait")
      def poundSign: CssStyle = fas("pound-sign")
      def powerOff: CssStyle = fas("power-off")
      def pray: CssStyle = fas("pray")
      def prayingHands: CssStyle = fas("praying-hands")
      def prescription: CssStyle = fas("prescription")
      def prescriptionBottle: CssStyle = fas("prescription-bottle")
      def prescriptionBottleAlt: CssStyle = fas("prescription-bottle-alt")
      def print: CssStyle = fas("print")
      def procedures: CssStyle = fas("procedures")
      def projectDiagram: CssStyle = fas("project-diagram")
      def puzzlePiece: CssStyle = fas("puzzle-piece")
      def qrcode: CssStyle = fas("qrcode")
      def question: CssStyle = fas("question")
      def questionCircle: CssStyle = fas("question-circle")
      def quidditch: CssStyle = fas("quidditch")
      def quoteLeft: CssStyle = fas("quote-left")
      def quoteRight: CssStyle = fas("quote-right")
      def quran: CssStyle = fas("quran")
      def radiation: CssStyle = fas("radiation")
      def radiationAlt: CssStyle = fas("radiation-alt")
      def rainbow: CssStyle = fas("rainbow")
      def random: CssStyle = fas("random")
      def receipt: CssStyle = fas("receipt")
      def recycle: CssStyle = fas("recycle")
      def redo: CssStyle = fas("redo")
      def redoAlt: CssStyle = fas("redo-alt")
      def registered: CssStyle = fas("registered")
      def removeFormat: CssStyle = fas("remove-format")
      def reply: CssStyle = fas("reply")
      def replyAll: CssStyle = fas("reply-all")
      def republican: CssStyle = fas("republican")
      def restroom: CssStyle = fas("restroom")
      def retweet: CssStyle = fas("retweet")
      def ribbon: CssStyle = fas("ribbon")
      def ring: CssStyle = fas("ring")
      def road: CssStyle = fas("road")
      def robot: CssStyle = fas("robot")
      def rocket: CssStyle = fas("rocket")
      def route: CssStyle = fas("route")
      def rss: CssStyle = fas("rss")
      def rssSquare: CssStyle = fas("rss-square")
      def rubleSign: CssStyle = fas("ruble-sign")
      def ruler: CssStyle = fas("ruler")
      def rulerCombined: CssStyle = fas("ruler-combined")
      def rulerHorizontal: CssStyle = fas("ruler-horizontal")
      def rulerVertical: CssStyle = fas("ruler-vertical")
      def running: CssStyle = fas("running")
      def rupeeSign: CssStyle = fas("rupee-sign")
      def sadCry: CssStyle = fas("sad-cry")
      def sadTear: CssStyle = fas("sad-tear")
      def satellite: CssStyle = fas("satellite")
      def satelliteDish: CssStyle = fas("satellite-dish")
      def save: CssStyle = fas("save")
      def school: CssStyle = fas("school")
      def screwdriver: CssStyle = fas("screwdriver")
      def scroll: CssStyle = fas("scroll")
      def sdCard: CssStyle = fas("sd-card")
      def search: CssStyle = fas("search")
      def searchDollar: CssStyle = fas("search-dollar")
      def searchLocation: CssStyle = fas("search-location")
      def searchMinus: CssStyle = fas("search-minus")
      def searchPlus: CssStyle = fas("search-plus")
      def seedling: CssStyle = fas("seedling")
      def server: CssStyle = fas("server")
      def shapes: CssStyle = fas("shapes")
      def share: CssStyle = fas("share")
      def shareAlt: CssStyle = fas("share-alt")
      def shareAltSquare: CssStyle = fas("share-alt-square")
      def shareSquare: CssStyle = fas("share-square")
      def shekelSign: CssStyle = fas("shekel-sign")
      def shieldAlt: CssStyle = fas("shield-alt")
      def ship: CssStyle = fas("ship")
      def shippingFast: CssStyle = fas("shipping-fast")
      def shoePrints: CssStyle = fas("shoe-prints")
      def shoppingBag: CssStyle = fas("shopping-bag")
      def shoppingBasket: CssStyle = fas("shopping-basket")
      def shoppingCart: CssStyle = fas("shopping-cart")
      def shower: CssStyle = fas("shower")
      def shuttleVan: CssStyle = fas("shuttle-van")
      def sign: CssStyle = fas("sign")
      def signInAlt: CssStyle = fas("sign-in-alt")
      def signLanguage: CssStyle = fas("sign-language")
      def signOutAlt: CssStyle = fas("sign-out-alt")
      def signal: CssStyle = fas("signal")
      def signature: CssStyle = fas("signature")
      def simCard: CssStyle = fas("sim-card")
      def sitemap: CssStyle = fas("sitemap")
      def skating: CssStyle = fas("skating")
      def skiing: CssStyle = fas("skiing")
      def skiingNordic: CssStyle = fas("skiing-nordic")
      def skull: CssStyle = fas("skull")
      def skullCrossbones: CssStyle = fas("skull-crossbones")
      def slash: CssStyle = fas("slash")
      def sleigh: CssStyle = fas("sleigh")
      def slidersH: CssStyle = fas("sliders-h")
      def smile: CssStyle = fas("smile")
      def smileBeam: CssStyle = fas("smile-beam")
      def smileWink: CssStyle = fas("smile-wink")
      def smog: CssStyle = fas("smog")
      def smoking: CssStyle = fas("smoking")
      def smokingBan: CssStyle = fas("smoking-ban")
      def sms: CssStyle = fas("sms")
      def snowboarding: CssStyle = fas("snowboarding")
      def snowflake: CssStyle = fas("snowflake")
      def snowman: CssStyle = fas("snowman")
      def snowplow: CssStyle = fas("snowplow")
      def socks: CssStyle = fas("socks")
      def solarPanel: CssStyle = fas("solar-panel")
      def sort: CssStyle = fas("sort")
      def sortAlphaDown: CssStyle = fas("sort-alpha-down")
      def sortAlphaDownAlt: CssStyle = fas("sort-alpha-down-alt")
      def sortAlphaUp: CssStyle = fas("sort-alpha-up")
      def sortAlphaUpAlt: CssStyle = fas("sort-alpha-up-alt")
      def sortAmountDown: CssStyle = fas("sort-amount-down")
      def sortAmountDownAlt: CssStyle = fas("sort-amount-down-alt")
      def sortAmountUp: CssStyle = fas("sort-amount-up")
      def sortAmountUpAlt: CssStyle = fas("sort-amount-up-alt")
      def sortDown: CssStyle = fas("sort-down")
      def sortNumericDown: CssStyle = fas("sort-numeric-down")
      def sortNumericDownAlt: CssStyle = fas("sort-numeric-down-alt")
      def sortNumericUp: CssStyle = fas("sort-numeric-up")
      def sortNumericUpAlt: CssStyle = fas("sort-numeric-up-alt")
      def sortUp: CssStyle = fas("sort-up")
      def spa: CssStyle = fas("spa")
      def spaceShuttle: CssStyle = fas("space-shuttle")
      def spellCheck: CssStyle = fas("spell-check")
      def spider: CssStyle = fas("spider")
      def spinner: CssStyle = fas("spinner")
      def splotch: CssStyle = fas("splotch")
      def sprayCan: CssStyle = fas("spray-can")
      def square: CssStyle = fas("square")
      def squareFull: CssStyle = fas("square-full")
      def squareRootAlt: CssStyle = fas("square-root-alt")
      def stamp: CssStyle = fas("stamp")
      def star: CssStyle = fas("star")
      def starAndCrescent: CssStyle = fas("star-and-crescent")
      def starHalf: CssStyle = fas("star-half")
      def starHalfAlt: CssStyle = fas("star-half-alt")
      def starOfDavid: CssStyle = fas("star-of-david")
      def starOfLife: CssStyle = fas("star-of-life")
      def stepBackward: CssStyle = fas("step-backward")
      def stepForward: CssStyle = fas("step-forward")
      def stethoscope: CssStyle = fas("stethoscope")
      def stickyNote: CssStyle = fas("sticky-note")
      def stop: CssStyle = fas("stop")
      def stopCircle: CssStyle = fas("stop-circle")
      def stopwatch: CssStyle = fas("stopwatch")
      def store: CssStyle = fas("store")
      def storeAlt: CssStyle = fas("store-alt")
      def stream: CssStyle = fas("stream")
      def streetView: CssStyle = fas("street-view")
      def strikethrough: CssStyle = fas("strikethrough")
      def stroopwafel: CssStyle = fas("stroopwafel")
      def subscript: CssStyle = fas("subscript")
      def subway: CssStyle = fas("subway")
      def suitcase: CssStyle = fas("suitcase")
      def suitcaseRolling: CssStyle = fas("suitcase-rolling")
      def sun: CssStyle = fas("sun")
      def superscript: CssStyle = fas("superscript")
      def surprise: CssStyle = fas("surprise")
      def swatchbook: CssStyle = fas("swatchbook")
      def swimmer: CssStyle = fas("swimmer")
      def swimmingPool: CssStyle = fas("swimming-pool")
      def synagogue: CssStyle = fas("synagogue")
      def sync: CssStyle = fas("sync")
      def syncAlt: CssStyle = fas("sync-alt")
      def syringe: CssStyle = fas("syringe")
      def table: CssStyle = fas("table")
      def tableTennis: CssStyle = fas("table-tennis")
      def tablet: CssStyle = fas("tablet")
      def tabletAlt: CssStyle = fas("tablet-alt")
      def tablets: CssStyle = fas("tablets")
      def tachometerAlt: CssStyle = fas("tachometer-alt")
      def tag: CssStyle = fas("tag")
      def tags: CssStyle = fas("tags")
      def tape: CssStyle = fas("tape")
      def tasks: CssStyle = fas("tasks")
      def taxi: CssStyle = fas("taxi")
      def teeth: CssStyle = fas("teeth")
      def teethOpen: CssStyle = fas("teeth-open")
      def temperatureHigh: CssStyle = fas("temperature-high")
      def temperatureLow: CssStyle = fas("temperature-low")
      def tenge: CssStyle = fas("tenge")
      def terminal: CssStyle = fas("terminal")
      def textHeight: CssStyle = fas("text-height")
      def textWidth: CssStyle = fas("text-width")
      def th: CssStyle = fas("th")
      def thLarge: CssStyle = fas("th-large")
      def thList: CssStyle = fas("th-list")
      def theaterMasks: CssStyle = fas("theater-masks")
      def thermometer: CssStyle = fas("thermometer")
      def thermometerEmpty: CssStyle = fas("thermometer-empty")
      def thermometerFull: CssStyle = fas("thermometer-full")
      def thermometerHalf: CssStyle = fas("thermometer-half")
      def thermometerQuarter: CssStyle = fas("thermometer-quarter")
      def thermometerThreeQuarters: CssStyle = fas("thermometer-three-quarters")
      def thumbsDown: CssStyle = fas("thumbs-down")
      def thumbsUp: CssStyle = fas("thumbs-up")
      def thumbtack: CssStyle = fas("thumbtack")
      def ticketAlt: CssStyle = fas("ticket-alt")
      def times: CssStyle = fas("times")
      def timesCircle: CssStyle = fas("times-circle")
      def tint: CssStyle = fas("tint")
      def tintSlash: CssStyle = fas("tint-slash")
      def tired: CssStyle = fas("tired")
      def toggleOff: CssStyle = fas("toggle-off")
      def toggleOn: CssStyle = fas("toggle-on")
      def toilet: CssStyle = fas("toilet")
      def toiletPaper: CssStyle = fas("toilet-paper")
      def toolbox: CssStyle = fas("toolbox")
      def tools: CssStyle = fas("tools")
      def tooth: CssStyle = fas("tooth")
      def torah: CssStyle = fas("torah")
      def toriiGate: CssStyle = fas("torii-gate")
      def tractor: CssStyle = fas("tractor")
      def trademark: CssStyle = fas("trademark")
      def trafficLight: CssStyle = fas("traffic-light")
      def train: CssStyle = fas("train")
      def tram: CssStyle = fas("tram")
      def transgender: CssStyle = fas("transgender")
      def transgenderAlt: CssStyle = fas("transgender-alt")
      def trash: CssStyle = fas("trash")
      def trashAlt: CssStyle = fas("trash-alt")
      def trashRestore: CssStyle = fas("trash-restore")
      def trashRestoreAlt: CssStyle = fas("trash-restore-alt")
      def tree: CssStyle = fas("tree")
      def trophy: CssStyle = fas("trophy")
      def truck: CssStyle = fas("truck")
      def truckLoading: CssStyle = fas("truck-loading")
      def truckMonster: CssStyle = fas("truck-monster")
      def truckMoving: CssStyle = fas("truck-moving")
      def truckPickup: CssStyle = fas("truck-pickup")
      def tshirt: CssStyle = fas("tshirt")
      def tty: CssStyle = fas("tty")
      def tv: CssStyle = fas("tv")
      def umbrella: CssStyle = fas("umbrella")
      def umbrellaBeach: CssStyle = fas("umbrella-beach")
      def underline: CssStyle = fas("underline")
      def undo: CssStyle = fas("undo")
      def undoAlt: CssStyle = fas("undo-alt")
      def universalAccess: CssStyle = fas("universal-access")
      def university: CssStyle = fas("university")
      def unlink: CssStyle = fas("unlink")
      def unlock: CssStyle = fas("unlock")
      def unlockAlt: CssStyle = fas("unlock-alt")
      def upload: CssStyle = fas("upload")
      def user: CssStyle = fas("user")
      def userAlt: CssStyle = fas("user-alt")
      def userAltSlash: CssStyle = fas("user-alt-slash")
      def userAstronaut: CssStyle = fas("user-astronaut")
      def userCheck: CssStyle = fas("user-check")
      def userCircle: CssStyle = fas("user-circle")
      def userClock: CssStyle = fas("user-clock")
      def userCog: CssStyle = fas("user-cog")
      def userEdit: CssStyle = fas("user-edit")
      def userFriends: CssStyle = fas("user-friends")
      def userGraduate: CssStyle = fas("user-graduate")
      def userInjured: CssStyle = fas("user-injured")
      def userLock: CssStyle = fas("user-lock")
      def userMd: CssStyle = fas("user-md")
      def userMinus: CssStyle = fas("user-minus")
      def userNinja: CssStyle = fas("user-ninja")
      def userNurse: CssStyle = fas("user-nurse")
      def userPlus: CssStyle = fas("user-plus")
      def userSecret: CssStyle = fas("user-secret")
      def userShield: CssStyle = fas("user-shield")
      def userSlash: CssStyle = fas("user-slash")
      def userTag: CssStyle = fas("user-tag")
      def userTie: CssStyle = fas("user-tie")
      def userTimes: CssStyle = fas("user-times")
      def users: CssStyle = fas("users")
      def usersCog: CssStyle = fas("users-cog")
      def utensilSpoon: CssStyle = fas("utensil-spoon")
      def utensils: CssStyle = fas("utensils")
      def vectorSquare: CssStyle = fas("vector-square")
      def venus: CssStyle = fas("venus")
      def venusDouble: CssStyle = fas("venus-double")
      def venusMars: CssStyle = fas("venus-mars")
      def vial: CssStyle = fas("vial")
      def vials: CssStyle = fas("vials")
      def video: CssStyle = fas("video")
      def videoSlash: CssStyle = fas("video-slash")
      def vihara: CssStyle = fas("vihara")
      def voicemail: CssStyle = fas("voicemail")
      def volleyballBall: CssStyle = fas("volleyball-ball")
      def volumeDown: CssStyle = fas("volume-down")
      def volumeMute: CssStyle = fas("volume-mute")
      def volumeOff: CssStyle = fas("volume-off")
      def volumeUp: CssStyle = fas("volume-up")
      def voteYea: CssStyle = fas("vote-yea")
      def vrCardboard: CssStyle = fas("vr-cardboard")
      def walking: CssStyle = fas("walking")
      def wallet: CssStyle = fas("wallet")
      def warehouse: CssStyle = fas("warehouse")
      def water: CssStyle = fas("water")
      def waveSquare: CssStyle = fas("wave-square")
      def weight: CssStyle = fas("weight")
      def weightHanging: CssStyle = fas("weight-hanging")
      def wheelchair: CssStyle = fas("wheelchair")
      def wifi: CssStyle = fas("wifi")
      def wind: CssStyle = fas("wind")
      def windowClose: CssStyle = fas("window-close")
      def windowMaximize: CssStyle = fas("window-maximize")
      def windowMinimize: CssStyle = fas("window-minimize")
      def windowRestore: CssStyle = fas("window-restore")
      def wineBottle: CssStyle = fas("wine-bottle")
      def wineGlass: CssStyle = fas("wine-glass")
      def wineGlassAlt: CssStyle = fas("wine-glass-alt")
      def wonSign: CssStyle = fas("won-sign")
      def wrench: CssStyle = fas("wrench")
      def xRay: CssStyle = fas("x-ray")
      def yenSign: CssStyle = fas("yen-sign")
      def yinYang: CssStyle = fas("yin-yang")
    }
  }
}
