/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXClientSessionImpl;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperation;
import com.intel.bluetooth.obex.OBEXOperationDelivery;
import com.intel.bluetooth.obex.OBEXOperationInputStream;
import com.intel.bluetooth.obex.OBEXOperationOutputStream;
import com.intel.bluetooth.obex.OBEXOperationReceive;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.obex.HeaderSet;
import javax.obex.Operation;

abstract class OBEXClientOperation
implements Operation,
OBEXOperation,
OBEXOperationReceive,
OBEXOperationDelivery {
    static final boolean SHORT_REQUEST_PHASE = true;
    protected OBEXClientSessionImpl session;
    protected char operationId;
    protected HeaderSet replyHeaders;
    protected boolean isClosed;
    protected boolean operationInProgress;
    protected boolean operationInContinue;
    protected OBEXOperationOutputStream outputStream;
    protected boolean outputStreamOpened = false;
    protected OBEXOperationInputStream inputStream;
    protected boolean inputStreamOpened = false;
    protected boolean errorReceived = false;
    protected boolean requestEnded = false;
    protected boolean finalBodyReceived = false;
    protected OBEXHeaderSetImpl startOperationHeaders = null;
    private boolean authenticationResponseCreated = false;
    protected Object lock;

    OBEXClientOperation(OBEXClientSessionImpl session, char operationId, OBEXHeaderSetImpl sendHeaders) throws IOException {
        this.session = session;
        this.operationId = operationId;
        this.isClosed = false;
        this.operationInProgress = false;
        this.lock = new Object();
        this.inputStream = new OBEXOperationInputStream(this);
        this.startOperation(sendHeaders);
    }

    static boolean isShortRequestPhase() {
        return true;
    }

    protected void startOperation(OBEXHeaderSetImpl sendHeaders) throws IOException {
        this.startOperationHeaders = sendHeaders;
    }

    @Override
    public void receiveData(OBEXOperationInputStream is) throws IOException {
        this.exchangePacket(this.startOperationHeaders);
        this.startOperationHeaders = null;
    }

    @Override
    public void deliverPacket(boolean finalPacket, byte[] buffer) throws IOException {
        if (this.requestEnded) {
            return;
        }
        if (this.startOperationHeaders != null) {
            this.exchangePacket(this.startOperationHeaders);
            this.startOperationHeaders = null;
        }
        int dataHeaderID = 72;
        if (finalPacket) {
            this.operationId = (char)(this.operationId | 0x80);
            dataHeaderID = 73;
            DebugLog.debug("client Request Phase ended");
            this.requestEnded = true;
        }
        OBEXHeaderSetImpl dataHeaders = OBEXSessionBase.createOBEXHeaderSetImpl();
        dataHeaders.setHeader(dataHeaderID, buffer);
        this.exchangePacket(dataHeaders);
    }

    protected void endRequestPhase() throws IOException {
        if (this.requestEnded) {
            return;
        }
        DebugLog.debug("client ends Request Phase");
        this.operationInProgress = false;
        this.requestEnded = true;
        this.operationId = (char)(this.operationId | 0x80);
        this.exchangePacket(this.startOperationHeaders);
        this.startOperationHeaders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exchangePacket(OBEXHeaderSetImpl headers) throws IOException {
        boolean success = false;
        try {
            this.session.writePacket(this.operationId, headers);
            byte[] b = this.session.readPacket();
            OBEXHeaderSetImpl dataHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
            this.session.handleAuthenticationResponse(dataHeaders, null);
            int responseCode = dataHeaders.getResponseCode();
            DebugLog.debug0x("client operation got reply", OBEXUtils.toStringObexResponseCodes(responseCode), responseCode);
            switch (responseCode) {
                case 193: {
                    if (!this.authenticationResponseCreated && dataHeaders.hasAuthenticationChallenge()) {
                        DebugLog.debug("client resend request with auth response");
                        OBEXHeaderSetImpl retryHeaders = OBEXHeaderSetImpl.cloneHeaders(headers);
                        this.session.handleAuthenticationChallenge(dataHeaders, retryHeaders);
                        this.authenticationResponseCreated = true;
                        this.exchangePacket(retryHeaders);
                        break;
                    }
                    this.errorReceived = true;
                    this.operationInContinue = false;
                    this.processIncommingHeaders(dataHeaders);
                    throw new IOException("Authentication Failure");
                }
                case 160: {
                    this.processIncommingHeaders(dataHeaders);
                    this.processIncommingData(dataHeaders, true);
                    this.operationInProgress = false;
                    this.operationInContinue = false;
                    break;
                }
                case 144: {
                    this.processIncommingHeaders(dataHeaders);
                    this.processIncommingData(dataHeaders, false);
                    this.operationInContinue = true;
                    break;
                }
                default: {
                    this.errorReceived = true;
                    this.operationInContinue = false;
                    this.processIncommingHeaders(dataHeaders);
                    this.processIncommingData(dataHeaders, true);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.errorReceived = true;
            }
        }
    }

    protected void processIncommingHeaders(HeaderSet dataHeaders) throws IOException {
        if (this.replyHeaders != null) {
            OBEXHeaderSetImpl.appendHeaders(dataHeaders, this.replyHeaders);
        }
        this.replyHeaders = dataHeaders;
    }

    protected void processIncommingData(HeaderSet dataHeaders, boolean eof) throws IOException {
        byte[] data = (byte[])dataHeaders.getHeader(72);
        if (data == null && (data = (byte[])dataHeaders.getHeader(73)) != null) {
            this.finalBodyReceived = true;
            eof = true;
        }
        if (data != null) {
            DebugLog.debug("client received Data eof: " + eof + " len: ", data.length);
            this.inputStream.appendData(data, eof);
        } else if (eof) {
            this.inputStream.appendData(null, eof);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws IOException {
        this.validateOperationIsOpen();
        if (!this.operationInProgress && !this.operationInContinue) {
            throw new IOException("the transaction has already ended");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.outputStream != null) {
                this.outputStream.abort();
            }
            this.inputStream.close();
        }
        this.writeAbort();
    }

    private void writeAbort() throws IOException {
        try {
            this.session.writePacket(255, null);
            this.requestEnded = true;
            byte[] b = this.session.readPacket();
            OBEXHeaderSetImpl dataHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
            if (dataHeaders.getResponseCode() != 160) {
                throw new IOException("Fails to abort operation, received " + OBEXUtils.toStringObexResponseCodes(dataHeaders.getResponseCode()));
            }
        }
        finally {
            this.isClosed = true;
            this.closeStream();
        }
    }

    private void closeStream() throws IOException {
        try {
            this.receiveOperationEnd();
        }
        finally {
            this.operationInProgress = false;
            this.inputStream.close();
            this.closeOutputStream();
        }
    }

    private void receiveOperationEnd() throws IOException {
        while (!this.isClosed() && this.operationInContinue) {
            DebugLog.debug("operation expects operation end");
            this.receiveData(this.inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutputStream() throws IOException {
        if (this.outputStream != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                this.outputStream = null;
            }
        }
    }

    protected void validateOperationIsOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
    }

    @Override
    public HeaderSet getReceivedHeaders() throws IOException {
        this.validateOperationIsOpen();
        this.endRequestPhase();
        return OBEXHeaderSetImpl.cloneHeaders(this.replyHeaders);
    }

    @Override
    public int getResponseCode() throws IOException {
        this.validateOperationIsOpen();
        this.endRequestPhase();
        this.closeOutputStream();
        this.receiveOperationEnd();
        return this.replyHeaders.getResponseCode();
    }

    @Override
    public void sendHeaders(HeaderSet headers) throws IOException {
        if (headers == null) {
            throw new NullPointerException("headers are null");
        }
        OBEXHeaderSetImpl.validateCreatedHeaderSet(headers);
        this.validateOperationIsOpen();
        if (this.requestEnded) {
            throw new IOException("the request phase has already ended");
        }
        if (this.startOperationHeaders != null) {
            this.exchangePacket(this.startOperationHeaders);
            this.startOperationHeaders = null;
        }
        this.exchangePacket((OBEXHeaderSetImpl)headers);
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public long getLength() {
        Long len;
        try {
            len = (Long)this.replyHeaders.getHeader(195);
        }
        catch (IOException e) {
            return -1L;
        }
        if (len == null) {
            return -1L;
        }
        return len;
    }

    @Override
    public String getType() {
        try {
            return (String)this.replyHeaders.getHeader(66);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    @Override
    public void close() throws IOException {
        try {
            this.endRequestPhase();
        }
        finally {
            this.closeStream();
            if (!this.isClosed) {
                this.isClosed = true;
                DebugLog.debug("client operation closed");
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed || this.errorReceived;
    }
}

