/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.obex.OBEXClientOperation;
import com.intel.bluetooth.obex.OBEXClientOperationGet;
import com.intel.bluetooth.obex.OBEXClientOperationPut;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.StreamConnection;
import javax.obex.Authenticator;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import javax.obex.Operation;

public class OBEXClientSessionImpl
extends OBEXSessionBase
implements ClientSession {
    protected OBEXClientOperation operation;
    private static final String FQCN = OBEXClientSessionImpl.class.getName();
    private static final Vector fqcnSet = new Vector();

    public OBEXClientSessionImpl(StreamConnection conn, OBEXConnectionParams obexConnectionParams) throws IOException, Error {
        super(conn, obexConnectionParams);
        Utils.isLegalAPICall(fqcnSet);
        this.requestSent = false;
        this.isConnected = false;
        this.operation = null;
    }

    @Override
    public HeaderSet createHeaderSet() {
        return OBEXSessionBase.createOBEXHeaderSet();
    }

    @Override
    public HeaderSet connect(HeaderSet headers) throws IOException {
        return this.connectImpl(headers, false);
    }

    private HeaderSet connectImpl(HeaderSet headers, boolean retry) throws IOException {
        OBEXClientSessionImpl.validateCreatedHeaderSet(headers);
        if (this.isConnected) {
            throw new IOException("Session already connected");
        }
        byte[] connectRequest = new byte[]{16, 0, OBEXUtils.hiByte(this.obexConnectionParams.mtu), OBEXUtils.loByte(this.obexConnectionParams.mtu)};
        this.writePacketWithFlags(128, connectRequest, (OBEXHeaderSetImpl)headers);
        byte[] b = this.readPacket();
        if (b.length < 6) {
            if (b.length == 3) {
                throw new IOException("Invalid response from OBEX server " + OBEXUtils.toStringObexResponseCodes(b[0]));
            }
            throw new IOException("Invalid response from OBEX server");
        }
        int serverMTU = OBEXUtils.bytesToShort(b[5], b[6]);
        if (serverMTU < 255) {
            throw new IOException("Invalid MTU " + serverMTU);
        }
        if (serverMTU < this.mtu) {
            this.mtu = serverMTU;
        }
        DebugLog.debug("mtu selected", this.mtu);
        OBEXHeaderSetImpl responseHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 7);
        Object connID = responseHeaders.getHeader(203);
        if (connID != null) {
            this.connectionID = (Long)connID;
        }
        this.validateAuthenticationResponse((OBEXHeaderSetImpl)headers, responseHeaders);
        if (!retry && responseHeaders.getResponseCode() == 193 && responseHeaders.hasAuthenticationChallenge()) {
            OBEXHeaderSetImpl replyHeaders = OBEXHeaderSetImpl.cloneHeaders(headers);
            this.handleAuthenticationChallenge(responseHeaders, replyHeaders);
            return this.connectImpl(replyHeaders, true);
        }
        if (responseHeaders.getResponseCode() == 160) {
            this.isConnected = true;
        }
        return responseHeaders;
    }

    @Override
    public HeaderSet disconnect(HeaderSet headers) throws IOException {
        OBEXClientSessionImpl.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        if (!this.isConnected) {
            throw new IOException("Session not connected");
        }
        this.writePacket(129, (OBEXHeaderSetImpl)headers);
        byte[] b = this.readPacket();
        this.isConnected = false;
        if (this.operation != null) {
            this.operation.close();
            this.operation = null;
        }
        return OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
    }

    @Override
    public void setConnectionID(long id) {
        if (id < 0L || id > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid connectionID " + id);
        }
        this.connectionID = id;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    protected void canStartOperation() throws IOException {
        if (!this.isConnected) {
            throw new IOException("Session not connected");
        }
        if (this.operation != null) {
            if (!this.operation.isClosed()) {
                throw new IOException("Client is already in an operation");
            }
            this.operation = null;
        }
    }

    @Override
    public HeaderSet setPath(HeaderSet headers, boolean backup, boolean create) throws IOException {
        OBEXClientSessionImpl.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        return this.setPathImpl(headers, backup, create, false);
    }

    private HeaderSet setPathImpl(HeaderSet headers, boolean backup, boolean create, boolean authentRetry) throws IOException {
        byte[] request = new byte[]{(byte)((backup ? 1 : 0) | (create ? 0 : 2)), 0};
        this.writePacketWithFlags(133, request, (OBEXHeaderSetImpl)headers);
        byte[] b = this.readPacket();
        OBEXHeaderSetImpl responseHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
        this.validateAuthenticationResponse((OBEXHeaderSetImpl)headers, responseHeaders);
        if (!authentRetry && responseHeaders.getResponseCode() == 193 && responseHeaders.hasAuthenticationChallenge()) {
            OBEXHeaderSetImpl retryHeaders = OBEXHeaderSetImpl.cloneHeaders(headers);
            this.handleAuthenticationChallenge(responseHeaders, retryHeaders);
            return this.setPathImpl(retryHeaders, backup, create, true);
        }
        return responseHeaders;
    }

    @Override
    public Operation get(HeaderSet headers) throws IOException {
        OBEXClientSessionImpl.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        this.operation = new OBEXClientOperationGet(this, (OBEXHeaderSetImpl)headers);
        return this.operation;
    }

    @Override
    public Operation put(HeaderSet headers) throws IOException {
        OBEXClientSessionImpl.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        this.operation = new OBEXClientOperationPut(this, (OBEXHeaderSetImpl)headers);
        return this.operation;
    }

    @Override
    public HeaderSet delete(HeaderSet headers) throws IOException {
        OBEXClientSessionImpl.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        return this.deleteImp(headers, false);
    }

    HeaderSet deleteImp(HeaderSet headers, boolean authentRetry) throws IOException {
        this.writePacket(130, (OBEXHeaderSetImpl)headers);
        byte[] b = this.readPacket();
        OBEXHeaderSetImpl responseHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
        this.validateAuthenticationResponse((OBEXHeaderSetImpl)headers, responseHeaders);
        if (!authentRetry && responseHeaders.getResponseCode() == 193 && responseHeaders.hasAuthenticationChallenge()) {
            OBEXHeaderSetImpl retryHeaders = OBEXHeaderSetImpl.cloneHeaders(headers);
            this.handleAuthenticationChallenge(responseHeaders, retryHeaders);
            return this.deleteImp(retryHeaders, true);
        }
        return responseHeaders;
    }

    @Override
    public void setAuthenticator(Authenticator auth) {
        if (auth == null) {
            throw new NullPointerException("auth is null");
        }
        this.authenticator = auth;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.operation != null) {
                this.operation.close();
                this.operation = null;
            }
        }
        finally {
            super.close();
        }
    }

    static {
        fqcnSet.addElement(FQCN);
    }
}

