/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ImportManager {
    private final String defaultPackage;
    private final Set<String> importSet = new LinkedHashSet<String>();

    public ImportManager(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public String addImport(Class<?> type) {
        if (!(Objects.requireNonNull(type).isPrimitive() || "java.lang".equals(type.getPackage().getName()) || this.defaultPackage != null && this.defaultPackage.equals(type.getPackage().getName()))) {
            this.importSet.add(type.getCanonicalName());
        }
        return type.getSimpleName();
    }

    public String addImport(String type) {
        int lastIndexOf = Objects.requireNonNull(type).lastIndexOf(".");
        if (lastIndexOf == -1) {
            return type;
        }
        String typePackage = type.substring(0, lastIndexOf);
        if (!typePackage.equals(this.defaultPackage)) {
            this.importSet.add(type);
        }
        return type.substring(typePackage.length() + 1);
    }

    public List<String> getImportsList() {
        LinkedList<String> importList = new LinkedList<String>(this.importSet);
        importList.sort(String::compareTo);
        return importList;
    }

    public String getImportsSection(String eol) {
        StringBuilder importsBuilder = new StringBuilder();
        for (String importType : this.getImportsList()) {
            importsBuilder.append("import ").append(importType).append(";").append(eol);
        }
        return importsBuilder.toString();
    }
}

