/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import io.ultreia.java4all.util.LeftOrRight;
import io.ultreia.java4all.util.TwoSideContext;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface LeftOrRightContext<O>
extends TwoSideContext<LeftOrRight, O> {
    public static <O> LeftOrRightContext<O> of(O left, O right) {
        return new LeftOrRightContextImpl<O>(left, right);
    }

    default public <V> LeftOrRightContext<V> apply(Function<O, V> function) {
        return LeftOrRightContext.of(function.apply(this.left()), function.apply(this.right()));
    }

    default public <V, X> LeftOrRightContext<V> apply(LeftOrRightContext<X> otherContext, BiFunction<X, O, V> function) {
        return LeftOrRightContext.of(function.apply(otherContext.left(), this.left()), function.apply(otherContext.right(), this.right()));
    }

    default public LeftOrRightContext<O> flip() {
        return LeftOrRightContext.of(this.right(), this.left());
    }

    public static class LeftOrRightContextImpl<O>
    extends TwoSideContext.TwoSideContextImpl<LeftOrRight, O>
    implements LeftOrRightContext<O> {
        public LeftOrRightContextImpl(O left, O right) {
            super(left, right);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LeftOrRightContext)) {
                return false;
            }
            LeftOrRightContext that = (LeftOrRightContext)o;
            return Objects.equals(this.left(), that.left()) && Objects.equals(this.right(), that.right());
        }
    }
}

