/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import io.ultreia.java4all.util.TwoSide;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface TwoSideContext<S extends TwoSide, O> {
    public static <S extends TwoSide, O> TwoSideContext<S, O> of(O left, O right) {
        return new TwoSideContextImpl(left, right);
    }

    public O left();

    public O right();

    default public O onSameSide(S side) {
        return side.get(this.left(), this.right());
    }

    default public O onOppositeSide(S side) {
        return side.get(this.right(), this.left());
    }

    default public <V> TwoSideContext<S, V> apply(Function<O, V> function) {
        return TwoSideContext.of(function.apply(this.left()), function.apply(this.right()));
    }

    default public <V, X> TwoSideContext<S, V> apply(TwoSideContext<S, X> otherContext, BiFunction<X, O, V> function) {
        return TwoSideContext.of(function.apply(otherContext.left(), this.left()), function.apply(otherContext.right(), this.right()));
    }

    default public TwoSideContext<S, O> flip() {
        return TwoSideContext.of(this.right(), this.left());
    }

    default public void accept(Consumer<O> consumer) {
        consumer.accept(this.left());
        consumer.accept(this.right());
    }

    public static class TwoSideContextImpl<S extends TwoSide, O>
    implements TwoSideContext<S, O> {
        private final O left;
        private final O right;

        public TwoSideContextImpl(O left, O right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public final O left() {
            return this.left;
        }

        @Override
        public final O right() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TwoSideContext)) {
                return false;
            }
            TwoSideContext that = (TwoSideContext)o;
            return Objects.equals(this.left(), that.left()) && Objects.equals(this.right(), that.right());
        }

        public final int hashCode() {
            return Objects.hash(this.left(), this.right());
        }
    }
}

