/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Version
implements Comparable<Version>,
Serializable {
    private static final List<String> PRE_RELEASE_CLASSIFIERS = List.of("alpha", "beta", "rc", "m");
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    public static final Version VZERO = Version.create().build();
    public static final char DEFAULT_JOIN_COMPONENT_SEPARATOR = '.';
    protected static final VersionComparator VERSION_COMPARATOR = new VersionComparator();
    private static final long serialVersionUID = 1L;
    protected final List<VersionComponent<?, ?>> components;
    protected final List<String> componentSeparators;
    protected final boolean snapshot;
    protected transient String version;

    public static Version valueOf(String version) {
        return Version.create(version).build();
    }

    public static VersionBuilder create() {
        return new VersionBuilder();
    }

    public static VersionBuilder create(String version) {
        return new VersionBuilder().setVersion(version);
    }

    public static VersionBuilder create(Version version) {
        List<Comparable<?>> components = Version.toComparableList(version.getComponents());
        ArrayList<String> componentSeparators = new ArrayList<String>(version.getComponentSeparators());
        boolean snapshot = version.isSnapshot();
        return Version.create(components).setComponentSeparators(componentSeparators).setSnapshot(snapshot);
    }

    public static VersionBuilder create(List<Comparable<?>> components) {
        return new VersionBuilder().setComponents(components);
    }

    public static Version addSnapshot(Version version) {
        if (version.isSnapshot()) {
            throw new IllegalArgumentException("version " + version + "is already a snapshot");
        }
        return Version.create(version).setSnapshot(true).build();
    }

    public static Version removeSnapshot(Version version) {
        if (!version.isSnapshot()) {
            throw new IllegalArgumentException("version " + version + "is already a snapshot");
        }
        return Version.create(version).setSnapshot(false).build();
    }

    public static Version extractVersion(Version version, int component) {
        return Version.extractVersion(version, component, component);
    }

    public static Version extractVersion(Version version, int firstComponent, int lastComponent) {
        if (lastComponent < firstComponent) {
            throw new IllegalArgumentException("lastComponent must be greater or equals to firstComponent");
        }
        ArrayList components = new ArrayList();
        for (int index = firstComponent; index <= lastComponent; ++index) {
            Object component = version.getComponent(index).getValue();
            components.add((Comparable<?>)component);
        }
        return Version.create().setComponents(components).build();
    }

    public static Version increments(Version version) {
        return Version.increments(version, '.');
    }

    public static Version increments(Version version, char componentSeparator) {
        Version newVersion;
        VersionComponent<?, ?> lastComponent = version.getLastComponent();
        if (lastComponent instanceof StringVersionComponent) {
            newVersion = Version.create(version).addComponent(Integer.valueOf(1), componentSeparator).build();
        } else {
            int numberComponent = ((NumberVersionComponent)lastComponent).getValue();
            newVersion = Version.create(version).setComponent(version.getComponentCount() - 1, Integer.valueOf(numberComponent + 1)).build();
        }
        return newVersion;
    }

    public static Version increments(Version version, int componentPosition) {
        int numberComponent = version.getNumberComponent(componentPosition);
        return Version.create(version).setComponent(componentPosition, Integer.valueOf(numberComponent + 1)).build();
    }

    public static boolean equals(String version0, String version1) {
        Version v0 = Version.valueOf(version0);
        Version v1 = Version.valueOf(version1);
        return v0.equals(v1);
    }

    public static Version decrements(Version version, int componentPosition) {
        int numberComponent = version.getNumberComponent(componentPosition);
        Version.checkArgument(componentPosition > 0, "Component at position " + componentPosition + " values 0, can't decrement it.");
        return Version.create(version).setComponent(componentPosition, Integer.valueOf(numberComponent - 1)).build();
    }

    public static boolean smallerThan(String version0, String version1) {
        Version v0 = Version.valueOf(version0);
        Version v1 = Version.valueOf(version1);
        return v0.before(v1);
    }

    public static boolean greaterThan(String version0, String version1) {
        Version v0 = Version.valueOf(version0);
        Version v1 = Version.valueOf(version1);
        return v0.after(v1);
    }

    private static String substringBeforeLast(String str, String separator) {
        if (str.isEmpty() || separator.isEmpty()) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private static boolean isAsciiAlphanumeric(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9';
    }

    private static boolean isAsciiNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static List<Comparable<?>> toComparableList(List<VersionComponent<?, ?>> components) {
        return components.stream().map(VersionComponent::getValue).collect(Collectors.toList());
    }

    protected Version(List<VersionComponent<?, ?>> components, List<String> componentSeparators, boolean snapshot) {
        this.componentSeparators = List.copyOf(componentSeparators);
        this.components = List.copyOf(components);
        this.snapshot = snapshot;
    }

    public List<VersionComponent<?, ?>> getComponents() {
        return this.components;
    }

    public List<String> getComponentSeparators() {
        return this.componentSeparators;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public int getNumberComponent(int componentPosition) {
        VersionComponent<?, ?> comparable = this.getComponent(componentPosition);
        Version.checkState(comparable instanceof NumberVersionComponent, "component at " + componentPosition + " for version " + this + " is not a number (" + comparable + ")");
        return (Integer)comparable.getValue();
    }

    public String getTextComponent(int componentPosition) {
        VersionComponent<?, ?> comparable = this.getComponent(componentPosition);
        Version.checkState(comparable instanceof StringVersionComponent, "component at " + componentPosition + " for version " + this + " is not a string (" + comparable + ")");
        return (String)comparable.getValue();
    }

    public VersionComponent<?, ?> getComponent(int level) {
        Version.checkArgument(level > 0 || level < this.getComponentCount(), "not a valid level " + level + " for the Version " + this);
        return this.components.get(level);
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = String.valueOf(this.components.get(0).getValue());
            int nb = this.componentSeparators.size();
            for (int i = 0; i < nb; ++i) {
                this.version = this.version + this.componentSeparators.get(i);
                this.version = this.version + this.components.get(i + 1).getValue();
            }
            if (this.snapshot) {
                this.version = this.version + SNAPSHOT_SUFFIX;
            }
        }
        return this.version;
    }

    public String getValidName() {
        String validName = this.getVersion();
        validName = validName.replaceAll("[.\\-]", "_");
        return validName;
    }

    @Override
    public int compareTo(Version o) {
        return VERSION_COMPARATOR.compare(this, o);
    }

    public boolean beforeOrEquals(Version o) {
        int result = this.compareTo(o);
        return result <= 0;
    }

    public boolean before(Version o) {
        int result = this.compareTo(o);
        return result < 0;
    }

    public boolean afterOrEquals(Version o) {
        int result = this.compareTo(o);
        return result >= 0;
    }

    public boolean after(Version o) {
        int result = this.compareTo(o);
        return result > 0;
    }

    public String toString() {
        return this.getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        int result = this.components.hashCode();
        result = 31 * result + (this.snapshot ? 1 : 0);
        return result;
    }

    protected VersionComponent<?, ?> getLastComponent() {
        return this.components.get(this.getComponentCount() - 1);
    }

    public static interface VersionComponent<C extends Comparable<C>, V extends VersionComponent<C, V>>
    extends Serializable,
    Comparable<V> {
        public C getValue();
    }

    public static class VersionComparator
    implements Comparator<Version>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Version o1, Version o2) {
            int o1NbComponents = o1.getComponentCount();
            int o2NbComponents = o2.getComponentCount();
            int minComponentSize = Math.min(o1NbComponents, o2NbComponents);
            int maxComponentSize = Math.max(o1NbComponents, o2NbComponents);
            int result = 0;
            for (int i = 0; result == 0 && i < minComponentSize; ++i) {
                VersionComponent<?, ?> o1Component = o1.getComponent(i);
                VersionComponent<?, ?> o2Component = o2.getComponent(i);
                result = Objects.equals(o1Component.getClass(), o2Component.getClass()) ? o1Component.compareTo(o2Component) : (o1Component instanceof NumberVersionComponent ? 1 : -1);
            }
            if (result == 0 && minComponentSize != maxComponentSize) {
                StringVersionComponent stringVersionComponent;
                VersionComponent<?, ?> component;
                result = o2NbComponents == minComponentSize ? ((component = o1.getComponent(minComponentSize)) instanceof StringVersionComponent ? ((stringVersionComponent = (StringVersionComponent)component).isPreRelease() ? -1 : 1) : 1) : ((component = o2.getComponent(minComponentSize)) instanceof StringVersionComponent ? ((stringVersionComponent = (StringVersionComponent)component).isPreRelease() ? 1 : -1) : -1);
            }
            if (result == 0 && !Objects.equals(o1.isSnapshot(), o2.isSnapshot())) {
                result = o2.isSnapshot() ? 1 : -1;
            }
            return result;
        }
    }

    public static class VersionBuilder {
        protected Set<String> preReleaseClassifiers;
        protected Set<Character> splitSeparators = new HashSet<Character>();
        protected Character joinSeparator;
        protected String version;
        protected List<Comparable<?>> components;
        protected List<String> componentSeparators;
        protected boolean snapshot;

        public VersionBuilder() {
            this.splitSeparators.add(Character.valueOf('-'));
            this.splitSeparators.add(Character.valueOf('.'));
            this.splitSeparators.add(Character.valueOf('_'));
            this.joinSeparator = Character.valueOf('.');
            this.preReleaseClassifiers = new HashSet<String>();
            this.preReleaseClassifiers.addAll(PRE_RELEASE_CLASSIFIERS);
        }

        public VersionBuilder setVersion(String version) {
            Version.checkState(!this.fromComponents(), "Can't set version if components are filled");
            this.version = version;
            return this;
        }

        public VersionBuilder setComponents(List<Comparable<?>> components) {
            Version.checkState(!this.fromStringRepresentation(), "Can't set components if version is filled");
            this.components = components;
            return this;
        }

        public VersionBuilder setComponent(int level, Comparable<?> value) {
            Version.checkState(!this.fromStringRepresentation(), "Can't set components if version is filled");
            int size = this.components.size();
            Version.checkArgument(level >= 0 && level < size, "level should be in [0, " + (size - 1) + "]");
            this.components.set(level, value);
            return this;
        }

        public VersionBuilder addComponent(Comparable<?> value) {
            Version.checkState(!this.fromStringRepresentation(), "Can't set components if version is filled");
            this.components.add(value);
            return this;
        }

        public VersionBuilder addComponent(Comparable<?> value, char componentSeparator) {
            this.addComponent(value);
            if (this.componentSeparators == null) {
                this.componentSeparators = new ArrayList<String>(this.components.size() - 1);
                this.initSeparatorList(this.componentSeparators, this.components.size() - 2);
            }
            this.componentSeparators.add("" + componentSeparator);
            return this;
        }

        public VersionBuilder removeComponent(int level) {
            Version.checkState(!this.fromStringRepresentation(), "Can't set components if version is filled");
            int size = this.components.size();
            Version.checkArgument(level >= 0 && level < size, "level should be in [0, " + (size - 1) + "]");
            this.components.remove(level);
            if (this.componentSeparators != null) {
                this.componentSeparators.remove(level - 1);
            }
            return this;
        }

        public VersionBuilder setComponentSeparators(List<String> componentSeparators) {
            Version.checkState(!this.fromStringRepresentation(), "Can't set components if version is filled");
            Version.checkArgument(componentSeparators.size() == this.components.size() - 1, "Must have n-1 component separators if you have n components");
            this.componentSeparators = componentSeparators;
            return this;
        }

        public VersionBuilder setComponentSeparator(int level, char value) {
            Version.checkState(!this.fromStringRepresentation(), "Can't set components if version is filled");
            int size = this.components.size();
            Version.checkArgument(level >= 0 && level < size, "level should be in [0, " + (size - 2) + "]");
            this.componentSeparators.set(level, "" + value);
            return this;
        }

        public VersionBuilder setSnapshot(boolean snapshot) {
            Version.checkState(!this.fromStringRepresentation(), "Can't set snapshot if version is filled");
            this.snapshot = snapshot;
            return this;
        }

        public VersionBuilder setSplitSeparators(Set<Character> splitSeparators) {
            for (Character splitSeparator : splitSeparators) {
                Version.checkState(!Version.isAsciiAlphanumeric(splitSeparator.charValue()), "Can't use a alphanumeric splitSeparator");
            }
            this.splitSeparators = splitSeparators;
            return this;
        }

        public VersionBuilder setJoinSeparator(Character joinSeparator) {
            this.joinSeparator = joinSeparator;
            return this;
        }

        public VersionBuilder setPreReleaseClassifiers(Set<String> preReleaseClassifiers) {
            this.preReleaseClassifiers = preReleaseClassifiers;
            return this;
        }

        protected boolean fromStringRepresentation() {
            return this.version != null;
        }

        protected boolean fromComponents() {
            return this.components != null;
        }

        public Version build() {
            boolean finalSnapshot;
            ArrayList finalComponents = new ArrayList();
            ArrayList<String> finalComponentSeparators = new ArrayList<String>();
            if (this.fromComponents()) {
                finalSnapshot = this.snapshot;
                for (Comparable<?> component : this.components) {
                    boolean number = component instanceof Integer;
                    VersionComponent<?, ?> v = this.toVersionComponent(number, String.valueOf(component));
                    finalComponents.add(v);
                }
                if (this.componentSeparators != null && !this.componentSeparators.isEmpty()) {
                    finalComponentSeparators = new ArrayList<String>(this.componentSeparators);
                } else {
                    this.initSeparatorList(finalComponentSeparators, finalComponents.size() - 1);
                }
            } else if (this.fromStringRepresentation()) {
                finalSnapshot = this.version.endsWith(Version.SNAPSHOT_SUFFIX);
                String versionPart = Version.substringBeforeLast(this.version, Version.SNAPSHOT_SUFFIX);
                boolean numberState = false;
                String currentComponentStr = null;
                int l = versionPart.length();
                for (int i = 0; i < l; ++i) {
                    char currentChar = versionPart.charAt(i);
                    if (this.splitSeparators.contains(Character.valueOf(currentChar))) {
                        finalComponentSeparators.add("" + currentChar);
                        if (currentComponentStr == null) continue;
                        VersionComponent<?, ?> component = this.toVersionComponent(numberState, currentComponentStr);
                        finalComponents.add(component);
                        currentComponentStr = null;
                        continue;
                    }
                    boolean number = Version.isAsciiNumeric(currentChar);
                    if (currentComponentStr == null) {
                        currentComponentStr = "" + currentChar;
                        numberState = number;
                        continue;
                    }
                    if (numberState == number) {
                        currentComponentStr = currentComponentStr + currentChar;
                        continue;
                    }
                    VersionComponent<?, ?> component = this.toVersionComponent(numberState, currentComponentStr);
                    finalComponents.add(component);
                    finalComponentSeparators.add("");
                    numberState = number;
                    currentComponentStr = "" + currentChar;
                }
                if (currentComponentStr != null) {
                    VersionComponent<?, ?> component = this.toVersionComponent(numberState, currentComponentStr);
                    finalComponents.add(component);
                }
            } else {
                finalSnapshot = this.snapshot;
                finalComponents.add(new NumberVersionComponent(0));
            }
            if (finalComponentSeparators.isEmpty() && finalComponents.size() > 1) {
                this.initSeparatorList(finalComponentSeparators, finalComponents.size() - 1);
            }
            return new Version(finalComponents, finalComponentSeparators, finalSnapshot);
        }

        protected void initSeparatorList(List<String> list, int size) {
            for (int i = 0; i < size; ++i) {
                list.add("" + this.joinSeparator);
            }
        }

        protected VersionComponent<?, ?> toVersionComponent(boolean numberState, String currentComponentStr) {
            VersionComponent<Integer, NumberVersionComponent> component;
            if (numberState) {
                component = new NumberVersionComponent(Integer.valueOf(currentComponentStr));
            } else {
                boolean preRelease = this.preReleaseClassifiers.contains(currentComponentStr.toLowerCase());
                component = new StringVersionComponent(preRelease, currentComponentStr);
            }
            return component;
        }
    }

    public static class StringVersionComponent
    implements VersionComponent<String, StringVersionComponent> {
        private static final long serialVersionUID = 1L;
        protected final boolean preRelease;
        protected final String value;
        protected final String lowerCaseValue;

        public StringVersionComponent(boolean preRelease, String value) {
            this.preRelease = preRelease;
            this.value = value;
            this.lowerCaseValue = value.toLowerCase();
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringVersionComponent)) {
                return false;
            }
            return this.compareTo((StringVersionComponent)o) == 0;
        }

        public int hashCode() {
            int result = this.preRelease ? 1 : 0;
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public boolean isPreRelease() {
            return this.preRelease;
        }

        @Override
        public int compareTo(StringVersionComponent o) {
            int result;
            if (!Objects.equals(this.preRelease, o.preRelease)) {
                result = this.preRelease ? -1 : 1;
            } else if (this.preRelease) {
                int i0 = PRE_RELEASE_CLASSIFIERS.indexOf(this.getValue().toLowerCase());
                int i1 = PRE_RELEASE_CLASSIFIERS.indexOf(o.getValue().toLowerCase());
                result = i0 - i1;
            } else {
                result = this.lowerCaseValue.compareTo(o.lowerCaseValue);
            }
            return result;
        }
    }

    public static class NumberVersionComponent
    implements VersionComponent<Integer, NumberVersionComponent> {
        private static final long serialVersionUID = 1L;
        protected final Integer value;

        public NumberVersionComponent(Integer value) {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NumberVersionComponent)) {
                return false;
            }
            return this.compareTo((NumberVersionComponent)o) == 0;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public int compareTo(NumberVersionComponent o) {
            return this.value.compareTo(o.value);
        }
    }
}

