/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters;

import com.google.auto.service.AutoService;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ultreia.java4all.util.json.JsonAdapter;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;

@AutoService(value={JsonAdapter.class})
public class BlobAdapter
implements JsonSerializer<Blob>,
JsonDeserializer<Blob>,
JsonAdapter {
    @Override
    public Class<?> type() {
        return Blob.class;
    }

    public Blob deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        byte[] bytes = (byte[])context.deserialize(json, byte[].class);
        try {
            return new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new JsonParseException("could not create blob ", (Throwable)e);
        }
    }

    public JsonElement serialize(Blob src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            byte[] bytes = src.getBytes(1L, (int)src.length());
            return context.serialize((Object)bytes);
        }
        catch (SQLException e) {
            throw new JsonParseException("could not read blob ", (Throwable)e);
        }
    }
}

