/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters;

import com.google.auto.service.AutoService;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.TwoSide;
import io.ultreia.java4all.util.TwoSideContext;
import io.ultreia.java4all.util.json.JsonAdapter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

@AutoService(value={JsonAdapter.class})
public class TwoSideContextAdapter<S extends TwoSide, O>
implements JsonSerializer<TwoSideContext<S, O>>,
JsonDeserializer<TwoSideContext<S, O>>,
JsonAdapter {
    private static final String LEFT = "left";
    private static final String RIGHT = "right";

    public JsonElement serialize(TwoSideContext<S, O> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add(LEFT, context.serialize(src.left()));
        result.add(RIGHT, context.serialize(src.right()));
        return result;
    }

    public TwoSideContext<S, O> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Type type = ((ParameterizedType)TypeToken.get((Type)typeOfT).getType()).getActualTypeArguments()[1];
        Object left = context.deserialize(json.getAsJsonObject().get(LEFT), type);
        Object right = context.deserialize(json.getAsJsonObject().get(RIGHT), type);
        return TwoSideContext.of(left, right);
    }

    @Override
    public Class<?> type() {
        return TwoSideContext.class;
    }
}

