/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.matrix;

import io.ultreia.java4all.util.json.JsonAware;
import io.ultreia.java4all.util.matrix.DataMatrixDimension;
import io.ultreia.java4all.util.matrix.DataMatrixPoint;
import java.io.Serializable;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DataMatrix
implements JsonAware {
    private static final Logger log = LogManager.getLogger(DataMatrix.class);
    private static final Function<Object, String> DEFAULT_CELL_VALUE_FORMATTER = o -> o == null ? null : o.toString();
    private Object[][] data;
    private int width;
    private int height;
    private int x;
    private int y;
    private final transient Function<Object, String> cellValueFormatter;

    public DataMatrix() {
        this(null);
    }

    public DataMatrix(Function<Object, String> cellValueFormatter) {
        this.cellValueFormatter = cellValueFormatter == null ? DEFAULT_CELL_VALUE_FORMATTER : cellValueFormatter;
    }

    public static DataMatrixDimension getDimension(DataMatrix ... matrices) {
        int width = 0;
        int height = 0;
        for (DataMatrix request : matrices) {
            int nWidth = request.getX() + request.getWidth();
            int nHeight = request.getY() + request.getHeight();
            if (nWidth > width) {
                width = nWidth;
            }
            if (nHeight <= height) continue;
            height = nHeight;
        }
        return new DataMatrixDimension(width, height);
    }

    public static DataMatrix create(int positionX, int positionY, int width, int height) {
        DataMatrix result = new DataMatrix();
        result.setLocation(new DataMatrixPoint(positionX, positionY));
        result.setDimension(new DataMatrixDimension(width, height));
        result.createData();
        return result;
    }

    public static DataMatrix merge(DataMatrix ... matrices) {
        return DataMatrix.merge(-1, -1, matrices);
    }

    public static DataMatrix merge(int rows, int columns, DataMatrix ... matrices) {
        int width;
        int height;
        DataMatrixDimension dimension = DataMatrix.getDimension(matrices);
        log.debug(String.format("Merge dimension : %s", dimension));
        if (rows != -1 && rows != (height = dimension.getHeight())) {
            log.warn(String.format("No matching rows number : should have %d, but was %d", rows, height));
        }
        if (columns != -1 && columns != (width = dimension.getWidth())) {
            log.warn(String.format("No matching columns number : should have %d, but was %d", columns, width));
        }
        DataMatrix result = new DataMatrix();
        result.setDimension(dimension);
        result.createData();
        for (DataMatrix incoming : matrices) {
            result.copyData(incoming);
        }
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Object[][] getData() {
        return this.data;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void createData() {
        this.data = new Object[this.height][this.width];
    }

    public void setData(Object[][] data) {
        this.data = data;
    }

    public void copyData(DataMatrix incoming) {
        int x = incoming.getX();
        int y = incoming.getY();
        int height = incoming.getHeight();
        int width = incoming.getWidth();
        log.debug(String.format("copying incoming matrix (dim: %s, location: %s)", incoming.getDimension(), incoming.getLocation()));
        for (int i = 0; i < width; ++i) {
            if (x + i < 0) continue;
            for (int j = 0; j < height; ++j) {
                if (y + j < 0) continue;
                Serializable value = incoming.getValue(i, j);
                this.setValue(x + i, y + j, value);
            }
        }
    }

    public void simpleCopyRow(DataMatrix incoming, int with, int targetJ, int incomingJ) {
        for (int i = 0; i < with; ++i) {
            Serializable value = incoming.getValue(i, incomingJ);
            this.setValue(i, targetJ, value);
        }
    }

    public void copyRow(DataMatrix incoming, int width, int targetJ, int incomingX, int incomingJ, Set<Integer> keys, String[] result) {
        int index = 0;
        for (int i = 0; i < width; ++i) {
            Serializable value = incoming.getValue(i + incomingX, incomingJ);
            this.setValue(i, targetJ, value);
            if (!keys.contains(i)) continue;
            result[index++] = (String)((Object)value);
        }
    }

    public DataMatrixDimension getDimension() {
        return new DataMatrixDimension(this.width, this.height);
    }

    public void setDimension(DataMatrixDimension dim) {
        this.height = dim.getHeight();
        this.width = dim.getWidth();
    }

    public DataMatrixPoint getLocation() {
        return new DataMatrixPoint(this.x, this.y);
    }

    public void setLocation(DataMatrixPoint location) {
        this.x = location.getX();
        this.y = location.getY();
    }

    public Serializable getValue(int x, int y) {
        return this.data == null ? null : (Serializable)this.data[y][x];
    }

    public void setValue(int x, int y, Object data) {
        String cellData = this.formatCellValue(data);
        log.debug(String.format("Put data [%d,%d] = %s", x, y, cellData));
        this.data[y][x] = cellData;
    }

    public DataMatrix setValue(Object data) {
        String cellData = this.formatCellValue(data);
        for (int y = 0; y < this.y; ++y) {
            for (int x = 0; x < this.x; ++x) {
                this.data[y][x] = cellData;
            }
        }
        return this;
    }

    public String toString() {
        return new StringJoiner(", ", DataMatrix.class.getSimpleName() + "[", "]").add("dimension=" + this.getDimension()).add("location=" + this.getLocation()).toString();
    }

    public Function<Object, String> getCellValueFormatter() {
        return this.cellValueFormatter;
    }

    public String getClipboardContent(boolean copyRowHeaders, boolean copyColumnHeaders, boolean escapeCells, char sep) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        char eol = '\n';
        int rows = this.getHeight();
        for (int y = copyColumnHeaders ? 0 : 1; y < rows; ++y) {
            Object value;
            int x;
            int columns = this.getWidth() - 1;
            for (x = copyRowHeaders ? 0 : 1; x < columns; ++x) {
                value = this.getValue(x, y);
                if (escapeCells) {
                    value = this.escapeCell(value);
                }
                buffer.append(value).append(sep);
            }
            value = this.getValue(x, y);
            if (escapeCells) {
                value = this.escapeCell(value);
            }
            buffer.append(value);
            buffer.append(eol);
        }
        return buffer.toString();
    }

    private String escapeCell(Object value) {
        return String.format("\"%s\"", value == null ? "" : value.toString().replaceAll("\"", "\"\""));
    }

    private String formatCellValue(Object data) {
        return this.getCellValueFormatter().apply(data);
    }
}

