/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.sql;

import io.ultreia.java4all.util.GZips;
import io.ultreia.java4all.util.SingletonSupplier;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;

public class SqlScriptReader
implements Iterable<String>,
Closeable {
    private final SingletonSupplier<Reader> source;
    private final boolean skipComment;
    private final boolean skipTrim;
    private final AtomicLong statementCount = new AtomicLong();
    private final boolean gzip;
    private final Map<String, String> variables;

    public static SqlScriptReader of(String source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source)).build();
    }

    public static SqlScriptReader of(String[] source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source)).build();
    }

    public static SqlScriptReader of(Collection<String> source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source)).build();
    }

    public static SqlScriptReader of(Stream<String> source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source)).build();
    }

    public static SqlScriptReader of(byte[] source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source)).build();
    }

    public static SqlScriptReader of(Path source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source)).build();
    }

    public static SqlScriptReader of(URL source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source)).build();
    }

    public static SqlScriptReader of(InputStream source) {
        return SqlScriptReader.builder(source).build();
    }

    public static Builder builder(String source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source).getBytes());
    }

    public static Builder builder(String[] source) {
        return SqlScriptReader.builder(Arrays.stream(Objects.requireNonNull(source)));
    }

    public static Builder builder(Collection<String> source) {
        return SqlScriptReader.builder(Objects.requireNonNull(source).stream());
    }

    public static Builder builder(Stream<String> source) {
        return new Builder(SingletonSupplier.of(() -> new StringStreamReader(Objects.requireNonNull(source))), false);
    }

    public static Builder builder(InputStream content) {
        return new Builder(() -> new BufferedInputStream(Objects.requireNonNull(content)));
    }

    public static Builder builder(byte[] source) {
        return new Builder(() -> new BufferedInputStream(new ByteArrayInputStream(Objects.requireNonNull(source))));
    }

    public static Builder builder(Path source) {
        return new Builder(() -> {
            try {
                return new BufferedInputStream(Files.newInputStream(Objects.requireNonNull(source), new OpenOption[0]));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't get input stream from source: " + source, e);
            }
        });
    }

    public static Builder builder(URL source) {
        return new Builder(() -> {
            try {
                return new BufferedInputStream(Objects.requireNonNull(source).openStream());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't get input stream from source: " + source, e);
            }
        });
    }

    public static Builder builder(SqlScriptReader location) {
        return new Builder(location.getSource(), location.isGzip());
    }

    private SqlScriptReader(SingletonSupplier<Reader> source, boolean skipComment, boolean skipTrim, boolean gzip, Map<String, String> variables) {
        this.source = source;
        this.skipComment = skipComment;
        this.skipTrim = skipTrim;
        this.gzip = gzip;
        if (variables != null) {
            LinkedHashMap<String, String> builder = new LinkedHashMap<String, String>();
            variables.forEach((? super K k, ? super V v) -> builder.put(String.format("\\$\\{%s}", k), (String)v));
            variables = builder;
            if (variables.isEmpty()) {
                variables = null;
            }
        }
        this.variables = variables;
    }

    @Override
    public Iterator<String> iterator() {
        return this.skipComment || this.skipTrim ? new SqlFileReaderIteratorWithoutComment(this.source, this.statementCount, this.skipComment, this.skipTrim, this.variables) : new SqlFileReaderIterator(this.source, this.statementCount, this.variables);
    }

    public long getStatementCount() {
        return this.statementCount.get();
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public SingletonSupplier<Reader> getSource() {
        return this.source;
    }

    @Override
    public void close() throws IOException {
        if (this.source.withValue()) {
            this.source.get().close();
        }
    }

    static enum SqlFileParserState {
        NORMAL,
        QUOTE,
        COMMENT;

    }

    public static class ConcatenatedInputStream
    extends InputStream {
        public static final int EOF = -1;
        private static final InputStream AT_EOF = new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        };
        private final Iterator<InputStream> iter;
        private InputStream current;

        public ConcatenatedInputStream(Stream<InputStream> src) {
            this.iter = Objects.requireNonNull(src).iterator();
            this.next();
        }

        @Override
        public int read() throws IOException {
            int n = this.current.read();
            while (n == -1 && this.current != AT_EOF) {
                this.next();
                n = this.current.read();
            }
            return n;
        }

        private void next() {
            this.current = this.iter.hasNext() ? this.iter.next() : AT_EOF;
        }
    }

    public static class StringStreamReader
    extends BufferedReader {
        public StringStreamReader(Stream<String> data) {
            super(new InputStreamReader(new ConcatenatedInputStream(data.map(s -> new ByteArrayInputStream(s.getBytes())))));
        }
    }

    public static class SqlFileReaderIteratorWithoutComment
    implements Iterator<String> {
        private final SqlFileReaderIterator delegate;
        private final AtomicLong statementCount;
        private final boolean skipComment;
        private final boolean skipTrim;
        private String next;

        private SqlFileReaderIteratorWithoutComment(SingletonSupplier<Reader> source, AtomicLong statementCount, boolean skipComment, boolean skipTrim, Map<String, String> variables) {
            this.delegate = new SqlFileReaderIterator(source, new AtomicLong(0L), variables);
            this.statementCount = statementCount;
            this.skipComment = skipComment;
            this.skipTrim = skipTrim;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            boolean hasNext = this.delegate.hasNext();
            if (hasNext) {
                this.next = this.delegate.next();
                if (this.skipTrim && this.next.trim().isEmpty()) {
                    this.next = null;
                    return this.hasNext();
                }
                if (this.skipComment && this.next.trim().startsWith("--")) {
                    this.next = null;
                    return this.hasNext();
                }
            }
            return hasNext;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.statementCount.incrementAndGet();
            String next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class SqlFileReaderIterator
    implements Iterator<String> {
        private final SingletonSupplier<Reader> source;
        private final StringBuilder buffer;
        private final AtomicLong statementCount;
        private final Map<String, String> variables;
        private int scanner;

        private SqlFileReaderIterator(SingletonSupplier<Reader> source, AtomicLong statementCount, Map<String, String> variables) {
            this.source = source;
            this.statementCount = statementCount;
            this.variables = variables;
            this.buffer = new StringBuilder();
        }

        @Override
        public boolean hasNext() {
            return this.scanner != -1;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SqlFileParserState state = SqlFileParserState.NORMAL;
            this.buffer.setLength(0);
            try {
                while ((this.scanner = this.source.get().read()) != -1) {
                    char character = (char)this.scanner;
                    block1 : switch (state) {
                        case NORMAL: {
                            switch (character) {
                                case '\n': 
                                case '\r': {
                                    break block1;
                                }
                                case ';': {
                                    this.buffer.append(";");
                                    return this.returnStatement();
                                }
                                case '-': {
                                    int length = this.buffer.length();
                                    if (length != 0 && this.buffer.charAt(length - 1) == '-') {
                                        state = SqlFileParserState.COMMENT;
                                    }
                                    this.buffer.append(character);
                                    break block1;
                                }
                                case '\'': {
                                    state = SqlFileParserState.QUOTE;
                                    this.buffer.append(character);
                                    break block1;
                                }
                            }
                            this.buffer.append(character);
                            break;
                        }
                        case QUOTE: {
                            if (character == '\'') {
                                state = SqlFileParserState.NORMAL;
                                this.buffer.append(character);
                                break;
                            }
                            this.buffer.append(character);
                            break;
                        }
                        case COMMENT: {
                            switch (character) {
                                case '\n': 
                                case '\r': {
                                    return this.returnStatement();
                                }
                            }
                            this.buffer.append(character);
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            return this.returnStatement();
        }

        private String returnStatement() {
            this.statementCount.incrementAndGet();
            String statement = this.buffer.toString();
            return this.replaceVariablesInStatement(statement);
        }

        private String replaceVariablesInStatement(String statement) {
            if (this.variables != null && statement.contains("${")) {
                for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                    String variable = entry.getKey();
                    String value = entry.getValue();
                    statement = statement.replaceAll(variable, value);
                }
            }
            return statement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class Builder {
        private final boolean gzip;
        private final SingletonSupplier<Reader> sourceReader;
        private final Supplier<InputStream> source;
        private Charset encoding = StandardCharsets.UTF_8;
        private boolean skipComment = true;
        private boolean skipTrim = true;
        private Map<String, String> variables;

        public Builder(Supplier<InputStream> source) {
            this.source = Objects.requireNonNull(source);
            this.sourceReader = null;
            try {
                this.gzip = GZips.isGzipStream(source.get());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't determine if input stream is gzip", e);
            }
        }

        public Builder(SingletonSupplier<Reader> source, boolean gzip) {
            this.source = null;
            this.sourceReader = Objects.requireNonNull(source);
            this.gzip = gzip;
        }

        public Builder keepCommentLine() {
            this.skipComment = false;
            return this;
        }

        public Builder keepEmptyLine() {
            this.skipTrim = false;
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.encoding = Objects.requireNonNull(encoding);
            return this;
        }

        public SqlScriptReader build() {
            if (this.source != null) {
                InputStream stream = this.source.get();
                try {
                    if (this.gzip) {
                        stream = new GZIPInputStream(this.source.get());
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't get gzip input stream", e);
                }
                InputStream finalStream = stream;
                return new SqlScriptReader(SingletonSupplier.of(() -> new BufferedReader(new InputStreamReader(finalStream, this.encoding))), this.skipComment, this.skipTrim, this.gzip, this.variables);
            }
            return new SqlScriptReader(this.sourceReader, this.skipComment, this.skipTrim, this.gzip, this.variables);
        }

        public Builder setVariables(Map<String, String> variables) {
            this.variables = variables;
            return this;
        }
    }
}

