/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.sql;

import io.ultreia.java4all.util.sql.SqlScriptReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;

public class SqlScriptWriter
implements Closeable {
    private final Supplier<OutputStream> target;
    private final boolean skipComment;
    private final boolean skipTrim;
    private final BufferedWriter writer;
    private long statementCount;

    public static SqlScriptWriter of(Path target) {
        return SqlScriptWriter.builder(target).build();
    }

    public static SqlScriptWriter of(OutputStream target) {
        return SqlScriptWriter.builder(target).build();
    }

    public static Builder builder(Path target) {
        return new Builder(() -> {
            try {
                return Files.newOutputStream(target, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public static Builder builder(OutputStream target) {
        return new Builder(() -> target);
    }

    private SqlScriptWriter(Supplier<OutputStream> target, boolean skipComment, boolean skipTrim, boolean gzip, Charset encoding) {
        this.target = target;
        this.skipComment = skipComment;
        this.skipTrim = skipTrim;
        OutputStream stream = target.get();
        try {
            if (gzip) {
                stream = new GZIPOutputStream(stream);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't get output stream from: " + target, e);
        }
        this.writer = new BufferedWriter(new OutputStreamWriter(stream, encoding));
    }

    public void writeSql(String sql) {
        if (this.skipTrim && sql.trim().isEmpty()) {
            return;
        }
        if (this.skipComment && sql.trim().startsWith("--")) {
            return;
        }
        try {
            this.writer.write(sql);
            if (!sql.endsWith(";")) {
                this.writer.write(";");
            }
            this.writer.newLine();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("can't write sql: [%s] to path: %s", sql, this.target), e);
        }
        ++this.statementCount;
    }

    public long getStatementCount() {
        return this.statementCount;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void writeScript(Path sqlScriptFile) throws IOException {
        SqlScriptReader.Builder builder = SqlScriptReader.builder(sqlScriptFile);
        if (!this.skipComment) {
            builder.keepCommentLine();
        }
        if (!this.skipTrim) {
            builder.keepEmptyLine();
        }
        try (SqlScriptReader sqlScripReader = builder.build();){
            for (String statement : sqlScripReader) {
                this.writeSql(statement);
            }
        }
    }

    public void writeScript(SqlScriptReader sqlScripReader) throws IOException {
        for (String statement : sqlScripReader) {
            this.writeSql(statement);
        }
    }

    public static class Builder {
        private final Supplier<OutputStream> source;
        private Charset encoding = StandardCharsets.UTF_8;
        private boolean skipComment = true;
        private boolean skipTrim = true;
        private boolean gzip;

        public Builder(Supplier<OutputStream> source) {
            this.source = Objects.requireNonNull(source);
        }

        public Builder gzip() {
            this.gzip = true;
            return this;
        }

        public Builder keepCommentLine() {
            this.skipComment = false;
            return this;
        }

        public Builder keepEmptyLine() {
            this.skipTrim = false;
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.encoding = Objects.requireNonNull(encoding);
            return this;
        }

        public SqlScriptWriter build() {
            return new SqlScriptWriter(this.source, this.skipComment, this.skipTrim, this.gzip, this.encoding);
        }
    }
}

