/*
 * Decompiled with CFR 0.152.
 */
package io.umehara.ogmapper;

import io.umehara.ogmapper.OgMapper;
import io.umehara.ogmapper.domain.OgDeterminer;
import io.umehara.ogmapper.domain.OgStringTags;
import io.umehara.ogmapper.domain.OgTags;
import io.umehara.ogmapper.domain.OgType;
import io.umehara.ogmapper.service.HtmlFetcher;
import io.umehara.ogmapper.service.OgStringTagParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/umehara/ogmapper/DefaultOgMapper;", "Lio/umehara/ogmapper/OgMapper;", "htmlFetcher", "Lio/umehara/ogmapper/service/HtmlFetcher;", "ogStringTagParser", "Lio/umehara/ogmapper/service/OgStringTagParser;", "(Lio/umehara/ogmapper/service/HtmlFetcher;Lio/umehara/ogmapper/service/OgStringTagParser;)V", "formatDeterminer", "Lio/umehara/ogmapper/domain/OgDeterminer;", "maybeDeterminer", "", "formatType", "Lio/umehara/ogmapper/domain/OgType;", "maybeType", "formatUrl", "Ljava/net/URL;", "baseUrl", "ogImageUrl", "process", "Lio/umehara/ogmapper/domain/OgTags;", "urlToProcess", "simplifyTag", "maybeComplexTag", "ogmapper"})
public final class DefaultOgMapper
implements OgMapper {
    private final HtmlFetcher htmlFetcher;
    private final OgStringTagParser ogStringTagParser;

    @Override
    @Nullable
    public OgTags process(@NotNull URL urlToProcess) {
        Intrinsics.checkParameterIsNotNull((Object)urlToProcess, (String)"urlToProcess");
        String string = this.htmlFetcher.fetchHead(urlToProcess);
        if (string == null) {
            return null;
        }
        String document = string;
        OgStringTags ogStringTags = this.ogStringTagParser.parse(document);
        if (ogStringTags == null) {
            return null;
        }
        OgStringTags ogStringTags2 = ogStringTags;
        String string2 = ogStringTags2.getTitle();
        if (string2 == null) {
            string2 = urlToProcess.getHost();
        }
        String title = string2;
        OgType type = this.formatType(ogStringTags2.getType());
        URL uRL = this.formatUrl(urlToProcess, ogStringTags2.getUrl());
        if (uRL == null) {
            uRL = urlToProcess;
        }
        URL url = uRL;
        URL image = this.formatUrl(url, ogStringTags2.getImage());
        URL audio = this.formatUrl(url, ogStringTags2.getAudio());
        String description = ogStringTags2.getDescription();
        OgDeterminer determiner = this.formatDeterminer(ogStringTags2.getDeterminer());
        String locale = ogStringTags2.getLocale();
        String siteName = ogStringTags2.getSiteName();
        URL video = this.formatUrl(url, ogStringTags2.getVideo());
        String string3 = title;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"title");
        return new OgTags(string3, type, url, image, audio, description, determiner, locale, siteName, video);
    }

    private final URL formatUrl(URL baseUrl, String ogImageUrl) {
        block7: {
            block6: {
                if (ogImageUrl == null) break block6;
                CharSequence charSequence = ogImageUrl;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block7;
            }
            return null;
        }
        try {
            return new URL(ogImageUrl);
        }
        catch (MalformedURLException e) {
            if (Intrinsics.areEqual((Object)String.valueOf(StringsKt.first((CharSequence)ogImageUrl)), (Object)"/")) {
                String base = baseUrl.getProtocol() + "://" + baseUrl.getHost();
                return new URL(base + ogImageUrl);
            }
            return null;
        }
    }

    private final String simplifyTag(String maybeComplexTag) {
        String string = maybeComplexTag;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        String tag = string3;
        return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)tag, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null));
    }

    private final OgType formatType(String maybeType) {
        if (maybeType == null) {
            return OgType.WEBSITE;
        }
        OgType type = OgType.WEBSITE;
        try {
            type = OgType.valueOf(this.simplifyTag(maybeType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type;
    }

    private final OgDeterminer formatDeterminer(String maybeDeterminer) {
        if (maybeDeterminer == null) {
            return OgDeterminer.BLANK;
        }
        OgDeterminer determiner = OgDeterminer.BLANK;
        try {
            determiner = OgDeterminer.valueOf(this.simplifyTag(maybeDeterminer));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return determiner;
    }

    public DefaultOgMapper(@NotNull HtmlFetcher htmlFetcher, @NotNull OgStringTagParser ogStringTagParser) {
        Intrinsics.checkParameterIsNotNull((Object)htmlFetcher, (String)"htmlFetcher");
        Intrinsics.checkParameterIsNotNull((Object)ogStringTagParser, (String)"ogStringTagParser");
        this.htmlFetcher = htmlFetcher;
        this.ogStringTagParser = ogStringTagParser;
    }
}

