/*
 * Decompiled with CFR 0.152.
 */
package io.umehara.ogmapper.jsoup;

import io.umehara.ogmapper.domain.OgStringTags;
import io.umehara.ogmapper.service.OgStringTagParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lio/umehara/ogmapper/jsoup/JsoupOgStringTagParser;", "Lio/umehara/ogmapper/service/OgStringTagParser;", "()V", "findTag", "", "document", "Lorg/jsoup/nodes/Document;", "property", "parse", "Lio/umehara/ogmapper/domain/OgStringTags;", "html", "ogmapper"})
public final class JsoupOgStringTagParser
implements OgStringTagParser {
    @Override
    @Nullable
    public OgStringTags parse(@NotNull String html) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        Document document2 = document = Jsoup.parse((String)html);
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        String title = this.findTag(document2, "title");
        String type = this.findTag(document, "type");
        String image = this.findTag(document, "image");
        String url = this.findTag(document, "url");
        String audio = this.findTag(document, "audio");
        String description = this.findTag(document, "description");
        String determiner = this.findTag(document, "determiner");
        String locale = this.findTag(document, "locale");
        String siteName = this.findTag(document, "site_name");
        String video = this.findTag(document, "video");
        if (title == null && type == null && image == null && url == null && audio == null && description == null && determiner == null && locale == null && siteName == null && video == null) {
            return null;
        }
        return new OgStringTags(title, type, image, url, audio, description, determiner, locale, siteName, video);
    }

    private final String findTag(Document document, String property) {
        String tag = null;
        Elements ogTag = document.select("meta[property='og:" + property + "']");
        if (ogTag != null && ogTag.size() >= 1) {
            tag = ogTag.first().attr("content");
        }
        return tag;
    }
}

