/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js.providers.cdi;

import io.undertow.js.InjectionContext;
import io.undertow.js.InjectionProvider;
import io.undertow.js.UndertowScriptLogger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class CDIInjectionProvider
implements InjectionProvider {
    private volatile BeanManager beanManager;

    @Override
    public Object getObject(InjectionContext injectionContext) {
        Bean bean;
        if (this.beanManager == null) {
            this.lookupBeanManager();
        }
        if ((bean = this.beanManager.resolve(this.beanManager.getBeans(injectionContext.getName()))) == null) {
            throw UndertowScriptLogger.ROOT_LOGGER.couldNotFindBean(injectionContext.getName());
        }
        return this.getReference(bean, injectionContext);
    }

    @Override
    public String getPrefix() {
        return "cdi";
    }

    private <T> Object getReference(Bean<T> bean, InjectionContext injectionContext) {
        CreationalContext creationalContext = this.beanManager.createCreationalContext(bean);
        if (Dependent.class.equals((Object)bean.getScope())) {
            Object reference = bean.create(creationalContext);
            injectionContext.setRequestHandledCallback(() -> bean.destroy(reference, creationalContext));
            return reference;
        }
        return this.beanManager.getReference(bean, Object.class, creationalContext);
    }

    private synchronized void lookupBeanManager() {
        if (this.beanManager == null) {
            try {
                this.beanManager = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (this.beanManager == null) {
                this.beanManager = CDI.current().getBeanManager();
            }
            if (this.beanManager == null) {
                throw UndertowScriptLogger.ROOT_LOGGER.unableToLookupBeanManager();
            }
        }
    }
}

